% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryTable-combine.R
\name{combine.summaryTable}
\alias{combine.summaryTable}
\title{Combine summary statistics table}
\usage{
\method{combine}{summaryTable}(..., summaryTables, combineVar = NULL, combineDir = c("row", "col"))
}
\arguments{
\item{...}{\code{\link{summaryTable}} objects.}

\item{summaryTables}{List of \code{\link{summaryTable}} objects.}

\item{combineVar}{(optional) String with name
of a new variable tracking from which table
each record originally come from.\cr
The label for each table is extracted from the names
of the \code{summaryTables} list, or 1:length(tables)
if the list is not named.\cr
If not specified (by default), the tables will be combined
but the information on which input table:
each record from the combined table belongs to will
not be retained.}

\item{combineDir}{String indicating
on which direction: 'row' or 'col' (a.k.a column)
the information on the table appartenance 
(\code{combineVar}) will
be displayed when the table is exported.}
}
\value{
A combined \code{\link{summaryTable}}.
}
\description{
\itemize{
\item{A new table is created, combining the tables by rows.}
\item{The attributes of the combined summary table are 
obtained by combining the attributes of all summary tables
(and removing duplicates).}
}
}
\details{
\itemize{
\item{In case only a set of tables contain categorical variable,
in nested rows, so the \code{variable} and \code{variableGroup}
variables, these variables are included as last in 
the 'row variables' attribute of the combined table.}
\item{Only one row is retained for the columns totals
per column variable (the first one in order of appearance).\cr
The column totals are not included if the column
variable(s) are not the same across tables, or
if the totals differ between tables.}
}
}
\author{
Laure Cougnaud
}
