% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{accessors}
\alias{accessors}
\alias{get_counts}
\alias{get_counts.default}
\alias{get_counts.incidence2}
\alias{get_count_names}
\alias{get_count_names.default}
\alias{get_count_names.incidence2}
\alias{get_date_index}
\alias{get_date_index.default}
\alias{get_date_index.incidence2}
\alias{get_dates}
\alias{get_dates_name}
\alias{get_dates_name.default}
\alias{get_dates_name.incidence2}
\alias{get_group_names}
\alias{get_group_names.default}
\alias{get_group_names.incidence2}
\alias{get_timespan}
\alias{get_timespan.default}
\alias{get_timespan.incidence2}
\alias{get_n}
\alias{get_n.default}
\alias{get_n.incidence2}
\alias{get_interval.incidence2}
\title{Access various elements of an incidence object}
\usage{
get_counts(x, ...)

\method{get_counts}{default}(x, ...)

\method{get_counts}{incidence2}(x, ...)

get_count_names(x, ...)

\method{get_count_names}{default}(x, ...)

\method{get_count_names}{incidence2}(x, ...)

get_date_index(x, ...)

\method{get_date_index}{default}(x, ...)

\method{get_date_index}{incidence2}(x, ...)

get_dates(x, ...)

get_dates_name(x, ...)

\method{get_dates_name}{default}(x, ...)

\method{get_dates_name}{incidence2}(x, ...)

get_group_names(x, ...)

\method{get_group_names}{default}(x, ...)

\method{get_group_names}{incidence2}(x, ...)

get_timespan(x, ...)

\method{get_timespan}{default}(x, ...)

\method{get_timespan}{incidence2}(x, ...)

get_n(x)

\method{get_n}{default}(x)

\method{get_n}{incidence2}(x)

\method{get_interval}{incidence2}(x, integer = FALSE, ...)
}
\arguments{
\item{x}{An \code{\link[=incidence]{incidence()}} object.}

\item{...}{Not used.}

\item{integer}{When \code{TRUE}, the interval will be converted to an
integer vector if it is stored as a character in the incidence object.}
}
\value{
\itemize{
\item \code{get_counts}: The count vector from x.
}

\itemize{
\item \code{get_count_names()}: The name of the count variable of x.
}

\itemize{
\item \code{get_date_index()}: The date_index vector from x.
}

\itemize{
\item \code{get_dates()}: Same as \code{get_date_index()}.
}

\itemize{
\item \code{get_dates_name()}: The name of the date_index variable of x.
}

\itemize{
\item \code{get_group_names()}: a character vector of the group variables of x or
NULL if none are present.
}

\itemize{
\item \code{get_timespan()}: an \code{integer} denoting the timespan in days represented
by the incidence object.
}

\itemize{
\item \code{get_n()} The total number of cases stored in the object
}

\itemize{
\item \code{get_interval()}: if \code{integer = TRUE}, an integer vector, otherwise the
character value of the \code{interval}
}
}
\description{
Access various elements of an incidence object
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE)) {
  withAutoprint({
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    i <- incidence(dat,
                   date_index = date_of_onset,
                   groups = c(gender, hospital))

    get_counts(i)
    get_count_names(i)

    get_group_names(i)

    get_date_index(i)
    get_dates_name(i)

    get_interval(i)

    get_n(i)

    get_timespan(i)
  })
}

}
