% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.incidence2}
\alias{plot.incidence2}
\title{Plot an incidence object}
\usage{
\method{plot}{incidence2}(
  x,
  y,
  width = 1,
  colour_palette = vibrant,
  border_colour = NA,
  na_colour = "grey",
  alpha = 0.7,
  title = NULL,
  angle = 0,
  size = NULL,
  nrow = NULL,
  ...
)
}
\arguments{
\item{x}{\verb{<incidence2>} object.}

\item{y}{Not used.

Required for compatibility with the \code{plot()} generic.}

\item{width}{\verb{[numeric]}

Value between 0 and 1 indicating the relative size of the bars to the
interval.

Default 1.}

\item{colour_palette}{\verb{[function]}

The color palette to be used for the different count variables.

Defaults to \code{vibrant} (see \code{?palettes}).}

\item{border_colour}{\verb{[character]}

The color to be used for the borders of the bars.

Use \code{NA} (default) for invisible borders.}

\item{na_colour}{\verb{[character]}

The colour to plot \code{NA} values in graphs.

Defaults to \code{grey}.}

\item{alpha}{\verb{[numeric]}

The alpha level for color transparency, with 1 being fully opaque and
0 fully transparent

Defaults to 0.7.}

\item{title}{\verb{[character]}

Optional title for the graph.}

\item{angle}{\verb{[numeric]}

Rotation angle for text.}

\item{size}{\verb{[numeric]}

text size in pts.}

\item{nrow}{\verb{[integer]}

Number of rows used for facetting if there are group variables present and
just one count in the incidence object.}

\item{...}{Not currently used.}
}
\value{
\itemize{
\item A \verb{[ggplot2::ggplot()]} object.
}
}
\description{
\code{plot()} can be used to provide a quick bar plot of an incidence object.
}
\details{
\itemize{
\item Facetting will occur automatically if either grouping variables or
multiple counts are present.
\item If there are multiple count variables, each count will occupy a different
row of the resulting plot.
\item Utilises ggplot2 so this must be installed to use.
}
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE) && requireNamespace("ggplot2", quietly = TRUE)) {
  withAutoprint({
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist

    inci <- incidence(dat, date_index = "date_of_onset", groups = "hospital")
    plot(inci, angle = 45)

    inci2 <- regroup(inci)
    plot(inci2)
  })
}

}
