% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.incidence2}
\alias{plot.incidence2}
\title{Plot an incidence object}
\usage{
\method{plot}{incidence2}(
  x,
  y,
  width = 1,
  colour_palette = vibrant,
  border_colour = NA,
  na_colour = "grey",
  alpha = 0.7,
  fill = NULL,
  legend = c("right", "left", "bottom", "top", "none"),
  title = NULL,
  angle = 0,
  size = NULL,
  nrow = NULL,
  n_breaks = 6L,
  show_cases = FALSE,
  ...
)
}
\arguments{
\item{x}{\link[=incidence]{incidence2} object.}

\item{y}{Not used.

Required for compatibility with the \code{plot()} generic.}

\item{width}{\code{numeric}.

Value between 0 and 1 indicating the relative size of the bars to the
interval.

Default 1.}

\item{colour_palette}{\code{function}.

The color palette to be used for the different count variables.

Defaults to \code{vibrant} (see \code{?palettes}).}

\item{border_colour}{\code{character}.

The color to be used for the borders of the bars.

Use \code{NA} (default) for invisible borders.}

\item{na_colour}{\code{character}.

The colour to plot \code{NA} values in graphs.

Defaults to \code{grey}.}

\item{alpha}{\code{numeric}.

The alpha level for color transparency, with 1 being fully opaque and
0 fully transparent

Defaults to 0.7.}

\item{fill}{\code{character}.

Which variable to colour plots by.

Must be a \code{group} or \code{count} variable and will mean that variable is not used
for facetting.

If NULL no distinction if made for plot colours.}

\item{legend}{\code{character}.

Position of legend in plot.

Only applied if \code{fill} is not NULL.

One of "right" (default), "left", "bottom", "top" or "none".}

\item{title}{\code{character}.

Optional title for the graph.}

\item{angle}{\code{numeric}.

Rotation angle for text.}

\item{size}{\code{numeric}.

text size in pts.}

\item{nrow}{\code{integer}.

Number of rows used for facetting if there are group variables present and
just one count in the incidence object.

Numeric values are coerced to integer via \code{as.integer()}.}

\item{n_breaks}{\code{integer}.

Approximate number of breaks calculated using \code{scales::breaks_pretty()}.

Numeric values are coerced to integer via \code{as.integer()}.

Default 6L.}

\item{show_cases}{\code{logical}.

if \code{TRUE}, then each observation will be shown individually in a square
format.

Normally only used for outbreaks with a small number of cases.

Defaults to \code{FALSE}.}

\item{...}{Not currently used.}
}
\value{
\itemize{
\item A \code{ggplot2::ggplot()} object.
}
}
\description{
\code{plot()} can be used to provide a bar plot of an incidence object. Due
to the complexities with automating plotting it is some what experimental in
nature and it may be better to use ggplot2 directly.
}
\details{
\itemize{
\item Faceting will occur automatically if either grouping variables or
multiple counts are present.
\item If there are multiple count variables, each count will occupy a different
row of the resulting plot.
\item Utilises ggplot2 so this must be installed to use.
}
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE) && requireNamespace("ggplot2", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist

    inci <- incidence(dat, date_index = "date_of_onset", groups = "hospital")
    plot(inci, angle = 45)

    inci2 <- regroup(inci)
    plot(inci2)
}
\dontshow{data.table::setDTthreads(.old)}

}
