# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Maximum data size for the T* statistic
#'
#' Data at most this size should not cause an overflow in the computation
#' of Tau*. This may depend on the availability of 64-bit or 128-bit words
#' to the compiler in use.
#'
#' @return
#' 6721987087 in 128-bit mode,
#' 102569 in 64-bit mode.
#'
#' @seealso
#' \code{\link{tau.star.test}}
#'
#' @export max_taustar
#'
#' @examples
#' max_taustar()
max_taustar <- function() {
    .Call(`_independence_max_taustar`)
}

#' Maximum data size for Hoeffding's statistics
#'
#' Data at most this size should not cause an overflow in the computation
#' of Hoeffding's D statistic or its refinement. This may depend on the
#' availability of 64-bit or 128-bit words to the compiler in use.
#'
#' @return
#' 100413509 in 128-bit mode,
#' 14081 in 64-bit mode.
#'
#' @seealso
#' \code{\link{hoeffding.D.test}}
#' \code{\link{hoeffding.refined.test}}
#'
#' @export max_hoeffding
#'
#' @examples
#' max_hoeffding()
max_hoeffding <- function() {
    .Call(`_independence_max_hoeffding`)
}

#' Compute the Tau* statistic
#'
#' This is an internal CPP function, used by the R function
#' \code{\link{tau.star.test}}.
#'
#' Given (X1,Y1),...,(Xn,Yn), the Tau*_n statistic only depends on the
#' permutation P that satisfies rank Yi = P[rank Xi].
#' This function computes Tau*_n given P in O(n log n) time.
#'
#' @param perm
#'     An integer vector containing exactly 0,1,...,n-1 in any order.
#'
#'     The validity of the input is not checked by this function.
#'
#' @return
#'     The Tau* statistic of \code{perm}.
#'
#'     The normalization is such that \emph{-1/3 <= Tau* <= 2/3}.
#'
#'     The return value -1.0 indicates an error.
#'
#' @aliases calc.taustar
#'
#' @export
#'
#' @examples
#'
#' .calc.taustar(0:3)
#' ## [1] 0.6666667
#'
#' .calc.taustar(c(0,2,1,3))
#' ## [1] -0.3333333
#'
#' set.seed(397)
#' .calc.taustar(order(runif(1000))-1)
#' ## [1] 0.004392385
#'
.calc.taustar <- function(perm) {
    .Call(`_independence_calc_taustar`, perm)
}

#' Compute Hoeffding's D statistic
#'
#' This is an internal CPP function, used by the R function
#' \code{\link{hoeffding.D.test}}.
#'
#' Given (X1,Y1),...,(Xn,Yn), Hoeffding's Dn only depends on the
#' permutation P that satisfies rank Yi = P[rank Xi].
#' This function computes Dn given P in O(n log n) time.
#'
#' @param perm
#'     An integer vector containing exactly 0,1,...,n-1 in any order.
#'
#'     The validity of the input is not checked by this function.
#'
#' @return
#'     Hoeffding's D statistic of \code{perm}.
#'
#'     The normalization is such that \emph{-1/60 <= D <= 1/30}.
#'
#'     The return value -1.0 indicates an error.
#'
#' @export
#'
#' @examples
#'
#' .calc.hoeffding(0:4)
#' ## [1] 0.03333333
#'
#' .calc.hoeffding(c(0,3,2,1,4))
#' ## [1] -0.01666667
#'
#' set.seed(397)
#' .calc.hoeffding(order(runif(1000))-1) * 36
#' ## [1] 0.004349087
.calc.hoeffding <- function(perm) {
    .Call(`_independence_calc_hoeffding`, perm)
}

#' Compute the refined Hoeffding statistic
#'
#' This is an internal CPP function, used by the R function
#' \code{\link{hoeffding.refined.test}}.
#'
#' Given (X1,Y1),...,(Xn,Yn), the refined Hoeffding statistic Rn only depends
#' on the permutation P that satisfies rank Yi = P[rank Xi].
#' This function computes Rn given P in O(n log n) time.
#'
#' @param perm
#'     An integer vector containing exactly 0,1,...,n-1 in any order.
#'
#'     The validity of the input is not checked by this function.
#'
#' @return
#'     The refined Hoeffding statistic of \code{perm}.
#'
#'     The normalization is such that \emph{-1/180 <= R <= 1/90}.
#'
#'     The return value -1.0 indicates an error.
#'
#' @export
#'
#' @examples
#'
#' .calc.refined(0:4)
#' ## [1] 0.01111111
#'
#' .calc.refined(c(0,3,2,1,4))
#' ## [1] -0.005555556
#'
#' set.seed(397)
#' .calc.refined(order(runif(1000))-1) * 36
#' ## [1] 0.004414034
.calc.refined <- function(perm) {
    .Call(`_independence_calc_refined`, perm)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_independence_RcppExport_registerCCallable', PACKAGE = 'independence')
})
