% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{smallpox_nigeria_df}
\alias{smallpox_nigeria_df}
\title{Smallpox in Abakaliki, Nigeria, 1967}
\format{
A data frame with 32 observations and 8 variables:
\describe{
  \item{case_ID}{Integer identifier for each smallpox case}
  \item{date_of_onset}{Date of symptom onset}
  \item{age}{Age of the individual (integer)}
  \item{gender}{Factor with two levels indicating gender}
  \item{vaccinated}{Factor with two levels indicating if the individual was vaccinated}
  \item{vaccscar}{Factor with two levels indicating presence of vaccination scar}
  \item{ftc}{Factor with two levels; additional epidemiological classification}
  \item{compound}{Factor with nine levels indicating compound of residence}
}
}
\source{
Data taken from the outbreaks package version 1.9.0
}
\usage{
data(smallpox_nigeria_df)
}
\description{
This dataset, smallpox_nigeria_df, is a data frame containing data on 32 cases
of smallpox that occurred in Abakaliki, Nigeria, in 1967. These cases were first
described by Thompson and Foege (1968) and occurred predominantly in a religious group
that refused medical interventions.
}
\details{
The dataset name has been kept as 'smallpox_nigeria_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
