% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{prop_test}
\alias{prop_test}
\title{Tidy proportion test}
\usage{
prop_test(
  x,
  formula,
  response = NULL,
  explanatory = NULL,
  p = NULL,
  order = NULL,
  alternative = "two-sided",
  conf_int = TRUE,
  conf_level = 0.95,
  success = NULL,
  correct = NULL,
  z = FALSE,
  ...
)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{formula}{A formula with the response variable on the left and the
explanatory on the right, where an explanatory variable NULL indicates
a test of a single proportion.}

\item{response}{The variable name in \code{x} that will serve as the response.
This is alternative to using the \code{formula} argument. This is an alternative
to the formula interface.}

\item{explanatory}{The variable name in \code{x} that will serve as the
explanatory variable. Optional. This is an alternative to the formula
interface.}

\item{p}{A numeric vector giving the hypothesized null proportion of
success for each group.}

\item{order}{A string vector specifying the order in which the proportions
should be subtracted, where  \code{order = c("first", "second")} means
\code{"first" - "second"}. Ignored for one-sample tests, and optional for two
sample tests.}

\item{alternative}{Character string giving the direction of the alternative
hypothesis. Options are \code{"two-sided"} (default), \code{"greater"}, or \code{"less"}.
Only used when testing the null that a single proportion equals a given
value, or that two proportions are equal; ignored otherwise.}

\item{conf_int}{A logical value for whether to report the confidence
interval or not. \code{TRUE} by default, ignored if \code{p} is specified for a
two-sample test. Only used when testing the null that a single
proportion equals a given value, or that two proportions are equal;
ignored otherwise.}

\item{conf_level}{A numeric value between 0 and 1. Default value is 0.95.
Only used when testing the null that a single proportion equals a given
value, or that two proportions are equal; ignored otherwise.}

\item{success}{The level of \code{response} that will be considered a success, as
a string. Only used when testing the null that a single
proportion equals a given value, or that two proportions are equal;
ignored otherwise.}

\item{correct}{A logical indicating whether Yates' continuity correction
should be applied where possible. If \code{z = TRUE}, the \code{correct} argument will
be overwritten as \code{FALSE}. Otherwise defaults to \code{correct = TRUE}.}

\item{z}{A logical value for whether to report the statistic as a standard
normal deviate or a Pearson's chi-square statistic. \eqn{z^2}  is distributed
chi-square with 1 degree of freedom, though note that the user will likely
need to turn off Yates' continuity correction by setting \code{correct = FALSE}
to see this connection.}

\item{...}{Additional arguments for \link[stats:prop.test]{prop.test()}.}
}
\description{
A tidier version of \link[stats:prop.test]{prop.test()} for equal or given
proportions.
}
\details{
When testing with an explanatory variable with more than two levels, the
\code{order} argument as used in the package is no longer well-defined. The function
will thus raise a warning and ignore the value if supplied a non-NULL \code{order}
argument.

The columns present in the output depend on the output of both \code{\link[=prop.test]{prop.test()}}
and \code{\link[broom:tidy.htest]{broom::glance.htest()}}. See the latter's documentation for column
definitions; columns have been renamed with the following mapping:
\itemize{
\item \code{chisq_df} = \code{parameter}
\item \code{p_value} = \code{p.value}
\item \code{lower_ci} = \code{conf.low}
\item \code{upper_ci} = \code{conf.high}
}
}
\examples{
# two-sample proportion test for difference in proportions of
# college completion by respondent sex
prop_test(gss,
          college ~ sex,
          order = c("female", "male"))

# one-sample proportion test for hypothesized null
# proportion of college completion of .2
prop_test(gss,
          college ~ NULL,
          p = .2)

# report as a z-statistic rather than chi-square
# and specify the success level of the response
prop_test(gss,
          college ~ NULL,
          success = "degree",
          p = .2,
          z = TRUE)

}
\seealso{
Other wrapper functions: 
\code{\link{chisq_stat}()},
\code{\link{chisq_test}()},
\code{\link{observe}()},
\code{\link{t_stat}()},
\code{\link{t_test}()}
}
\concept{wrapper functions}
