% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_embedding}
\alias{plot_embedding}
\title{Plot embedding}
\usage{
plot_embedding(
  matrix,
  labels = NULL,
  method = "pca",
  colors = RColorBrewer::brewer.pal(length(unique(labels)), "Set1"),
  seed = 1,
  point_size = 1,
  cores = 1
)
}
\arguments{
\item{matrix}{Input matrix.}

\item{labels}{Input labels.}

\item{method}{Method to use for dimensionality reduction.}

\item{colors}{Colors to use for the plot.}

\item{seed}{Seed for the random number generator.}

\item{point_size}{Size of the points.}

\item{cores}{Set the number of threads when setting \emph{\code{method}} to \code{\link[uwot]{umap}} and \code{\link[Rtsne]{Rtsne}}.}
}
\value{
An embedding plot
}
\description{
Plot embedding
}
\examples{
data("example_matrix")
samples_use <- 1:200
plot_data <- example_matrix[samples_use, ]
labels <- sample(
  c("A", "B", "C", "D", "E"),
  nrow(plot_data),
  replace = TRUE
)

plot_embedding(
  plot_data,
  labels,
  method = "pca",
  point_size = 2
)

plot_embedding(
  plot_data,
  labels,
  method = "tsne",
  point_size = 2
)
}
