% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_network.R
\name{single_network}
\alias{single_network}
\title{Construct network for single target gene}
\usage{
single_network(
  matrix,
  regulators,
  target,
  cross_validation = FALSE,
  seed = 1,
  penalty = "L0",
  r_squared_threshold = 0,
  n_folds = 5,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{matrix}{An expression matrix.}

\item{regulators}{The regulator genes for which to infer the regulatory network.}

\item{target}{The target gene.}

\item{cross_validation}{Logical value, default is \emph{\code{FALSE}}, whether to use cross-validation.}

\item{seed}{The random seed for cross-validation, default is \emph{\code{1}}.}

\item{penalty}{The type of regularization, default is \emph{\code{L0}}.
This can take either one of the following choices: \emph{\code{L0}}, \emph{\code{L0L1}}, and \emph{\code{L0L2}}.
For high-dimensional and sparse data, \emph{\code{L0L2}} is more effective.}

\item{r_squared_threshold}{Threshold of \eqn{R^2} coefficient, default is \emph{\code{0}}.}

\item{n_folds}{The number of folds for cross-validation, default is \emph{\code{5}}.}

\item{verbose}{Logical value, default is \emph{\code{TRUE}}, whether to print progress messages.}

\item{...}{Parameters for other methods.}
}
\value{
A data frame of the single target gene network.
 The data frame has three columns:
 \item{regulator}{The regulator genes.}
 \item{target}{The target gene.}
 \item{weight}{The weight of the regulator gene on the target gene.}
}
\description{
Construct network for single target gene
}
\examples{
data("example_matrix")
head(
  single_network(
    example_matrix,
    regulators = colnames(example_matrix),
    target = "g1"
  )
)
head(
  single_network(
    example_matrix,
    regulators = colnames(example_matrix),
    target = "g1",
    cross_validation = TRUE
  )
)

single_network(
  example_matrix,
  regulators = c("g1", "g2", "g3"),
  target = "g1"
)
single_network(
  example_matrix,
  regulators = c("g1", "g2"),
  target = "g1"
)
}
