% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one-samp-prop-test.R
\name{prop_test}
\alias{prop_test}
\alias{prop_test.default}
\alias{prop_test.factor}
\title{One Sample Test of Proportion}
\usage{
prop_test(n, prob = 0.5, alternative = c("both", "less", "greater", "all"),
  ...)

\method{prop_test}{default}(n, prob = 0.5, alternative = c("both", "less",
  "greater", "all"), phat, ...)

\method{prop_test}{factor}(n, prob = 0.5, alternative = c("both", "less",
  "greater", "all"), ...)
}
\arguments{
\item{n}{number of observations}

\item{prob}{hypothesised proportion}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter.}

\item{...}{other arguments}

\item{phat}{observed proportion}
}
\value{
\code{prop_test} returns an object of class \code{"prop_test"}.
An object of class \code{"prop_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{phat}{proportion of 1's}
\item{p}{assumed probability of success}
\item{z}{z statistic}
\item{sig}{p-value for z statistic}
\item{alt}{alternative hypothesis}
\item{obs}{observed number of 0's and 1's}
\item{exp}{expected number of 0's and 1's}
\item{deviation}{deviation of observed from expected}
\item{std}{standardized resiudals}
}
\description{
\code{prop_test} compares proportion in one group to a
specified population proportion.
}
\examples{
# use as a calculator
prop_test(200, prob = 0.5, phat = 0.3)

# using data set
prop_test(as.factor(hsb$female), prob = 0.5)
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{prop.test}} \code{\link[stats]{binom.test}}
}

