% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{double.cent.assess.noRegression}
\alias{double.cent.assess.noRegression}
\alias{DCANR}
\title{Assessment of innate features and associations of two network centrality measures}
\usage{
double.cent.assess.noRegression(
  data,
  nodes.colname,
  centrality1.colname,
  centrality2.colname
)
}
\arguments{
\item{data}{A data frame containing the values of two continuous variables and the name of
observations (nodes).}

\item{nodes.colname}{The character format (quoted) name of the column containing
the name of observations (nodes).}

\item{centrality1.colname}{The character format (quoted) name of the column containing
the values of the Centrality_1 variable.}

\item{centrality2.colname}{The character format (quoted) name of the column containing
the values of the Centrality_2 variable.}
}
\value{
A list of nine objects including:
Summary of the basic statistics of two centrality measures (or any two other continuous variables)
The results of normality assessment of two variable (p-value > 0.05 imply that the variable is normally distributed).
Description of the normality assessment of the centrality1 (first variable).
Description of the normality assessment of the centrality2 (second variable).
The Hoeffding's D Statistic of dependence (ranging from -0.5 to 1).
Description of the dependence significance.
Correlation between variables based on the NNS method.
The last two objects are the conditional probability of deviation of two
centrality measures from their corresponding means in opposite directions based
on both the entire network and the split-half random sample of network nodes.
}
\description{
This function assesses innate features and the association of two centrality measures
(or any two other continuous variables) from the aspect of distribution mode, dependence,
linearity, partial-moments based correlation, and conditional probability of
deviating from corresponding means in opposite direction (centrality2 is used as the condition variable).
This function doesn't consider which variable is dependent and which one is
independent and no regression analysis is done.
Also, the correlation between two variables is assessed via non-linear non-parametric statistics (NNS).
For the conditional probability assessment, the centrality2 variable is considered
as the condition variable.
}
\examples{
MyData <- centrality.measures
My.metrics.assessment <- double.cent.assess.noRegression(data = MyData,
                                            nodes.colname = "name",
                                            centrality1.colname = "BetweennessCentrality",
                                            centrality2.colname = "NeighborhoodConnectivity")
}
\seealso{
\code{\link[nortest]{ad.test}} for Anderson-Darling test for normality,
\code{\link[Hmisc]{hoeffd}} for Matrix of Hoeffding's D Statistics, and
\code{\link[NNS]{NNS.dep}} for NNS Dependence

Other centrality association assessment functions: 
\code{\link{cond.prob.analysis}()},
\code{\link{double.cent.assess}()}
}
\concept{centrality association assessment functions}
\keyword{association_assessment}
\keyword{dependence_assessment}
