% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injector.R
\name{inject}
\alias{inject}
\title{Injects the callback function}
\usage{
inject(callback, binder = .binder)
}
\arguments{
\item{callback}{function to inject, a function accepting arguments
to be matched to injectable keys; no errors are thrown if no binding
is found for a key, this is the intended mechanic for optional
injection, if the callback is able to deal with a missing argument
the argument becomes optional}

\item{binder}{containing the injectables, defaults to root binder if
omitted}
}
\value{
result of the injected callback evaluation
}
\description{
Injects the callback function
}
\examples{
inject (function (two) two, define (two = function () 2, binder = binder ()))
inject (function (power) power (2, 4), 
        define (power = function (power) function (x, n) if (n < 1) 1 else x * power (x, n - 1)))
inject (function (fibonacci) fibonacci (8),
        define (fibonacci = function (fibonacci)
          function (n) if (n < 3) 1
                       else fibonacci (n - 1) + fibonacci (n - 2), binder = binder ()))
}

