% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injector.R
\name{multibind}
\alias{multibind}
\title{Aggregates multiple factories under one key}
\usage{
multibind(key, scope = default, combine = function(this, parent)
  base::c(this, parent), binder = .binder)
}
\arguments{
\item{key}{injectable bean identifier}

\item{scope}{of the bean, wraps the injected factory call
specifying provisioning strategy, if omitted a new bean instance
will be provisioned each time injection is requested; injectoR also
ships with with the singleton scope which will provide once and
cache the bean for subsequent calls. Interface allows for custom
scoping, the scope parameter must be a function accepting key (name)
and the provider - the wrapped injected factory call - a function
accepting no parameters responsible for actual provisioning}

\item{combine}{aggregation procedure for combination of context
and inherited values, a function accepting a list of injectable
values from the current binder context and a no argument function
to retrieve values of the parent context; if omitted will the binding
will aggregate all values}

\item{binder}{for this binding, if omitted the binding is added to
the root binder}
}
\value{
a function accepting one or more factories for adding
elements to the binding; naming the factories will result in named
values injected; optionally accepts a scope for the bindings, if
omitted defaults to provide on injection; please be aware that the
scope is called without key for unnamed multibinding
}
\description{
Aggregates multiple factories under one key
}
\examples{
multibind ('keys', binder = binder ()) (function () 'skeleton')
}

