% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{glplot}
\alias{glplot}
\title{Render Spatial* and inla.mesh objects using RGL}
\usage{
glplot(object, ...)
}
\arguments{
\item{object}{an object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
glplot is a generic function for renders various kinds of spatial objects, i.e. Spatial* data 
and inla.mesh objects. The function invokes particular methods which depend on the class of the first argument.
}
\examples{
\donttest{
if (require("rgl", quietly = TRUE) &&
    require("sphereplot", quietly = TRUE)) {

# Load pantropoical dolphin data

data("mexdolphin", package = "inlabru")

# Show the globe

globe()

# Add mesh, ship transects and dolphin sightings stored
# as inla.mesh, SpatialLines and SpatialPoints objects, respectively

glplot(mexdolphin$mesh)
glplot(mexdolphin$samplers)
glplot(mexdolphin$points)

}
}
}
\seealso{
Other inlabru RGL tools: \code{\link{globe}},
  \code{\link{glplot.SpatialLines}},
  \code{\link{glplot.SpatialPoints}},
  \code{\link{glplot.inla.mesh}}
}
\concept{inlabru RGL tools}
