% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{bru_forward_transformation}
\alias{bru_forward_transformation}
\alias{bru_inverse_transformation}
\title{Transformation tools}
\usage{
bru_forward_transformation(qfun, x, ..., tail.split. = 0)

bru_inverse_transformation(pfun, x, ..., tail.split. = NULL)
}
\arguments{
\item{qfun}{A quantile function object, such as \code{qexp}}

\item{x}{Values to be transformed}

\item{...}{Distribution parameters passed on to the \code{qfun} and \code{pfun} functions}

\item{tail.split.}{For x-values larger than \code{tail.split.}, upper quantile calculations
are used internally, and for smaller values lower quantile calculations are used. This
can avoid lack of accuracy in the distribution tails. If \code{NULL}, forward calculations split at 0,
and inverse calculations use lower tails only, potentially losing accuracy in the upper tails.}

\item{pfun}{A CDF function object, such as \code{pexp}}
}
\value{
\itemize{
\item For \code{bru_forward_transformation}, a numeric vector
}

\itemize{
\item For \code{bru_inverse_transformation}, a numeric vector
}
}
\description{
Tools for transforming between N(0,1) variables and other
distributions in predictor expressions
}
\examples{
\dontrun{
if (interactive()) {
  # EXAMPLE1
}
}
}
