% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertedModel.R
\name{ConvertedModel}
\alias{ConvertedModel}
\title{Converted torch-based model}
\usage{
ConvertedModel(modules_list, graph, input_nodes, output_nodes, dtype = "float")
}
\arguments{
\item{modules_list}{(\code{list})\cr
A list of all accepted layers created by the \code{\link{Converter}}
class during initialization.\cr}

\item{graph}{(\code{list})\cr
The \code{graph} argument gives a way to pass an input through
the model, which is especially relevant for non-sequential architectures.
It can be seen as a list of steps in which order the layers from
\code{modules_list} must be applied. The list contains the following elements:
\itemize{
\item \verb{$current_nodes}\cr
This list describes the current position and the number
of the respective intermediate values when passing through the model.
For example, \code{list(1,3,3)} means that in this step one output from the
first layer and two from the third layer (the numbers correspond to the
list indices from the \code{modules_list} argument) are available for
the calculation of the current layer with index \code{used_node}.
\item \verb{$used_node}\cr
The index of the layer from the \code{modules_list} argument
which will be applied in this step.
\item \verb{$used_idx}\cr
The indices of the outputs from \code{current_nodes}, which are
used as inputs of the current layer (\code{used_node}).
\item \verb{$times}\cr
The frequency of the output value, i.e., is the output used
more than once as an input for subsequent layers?\cr
}}

\item{input_nodes}{(\code{numeric})\cr
A vector of layer indices describing the input layers,
i.e., they are used as the starting point for the calculations.\cr}

\item{output_nodes}{(\code{numeric})\cr
A vector of layer indices describing the indices
of the output layers.\cr}

\item{dtype}{(\code{character(1)})\cr
The data type for all the calculations and defined tensors. Use
either \code{'float'} for \code{\link[torch:torch_dtype]{torch::torch_float}} or \code{'double'} for
\code{\link[torch:torch_dtype]{torch::torch_double}}.\cr}
}
\description{
This class stores all layers converted to \code{torch} in a module which can be
used like the original model (but \code{torch}-based). In addition, it provides
other functions that are useful for interpreting individual predictions or
explaining the entire model. This model is part of the class \code{\link{Converter}}
and is the core for all the necessary calculations in the methods provided
in this package.
}
\section{Method \code{forward()}}{


The forward method of the whole model, i.e., it calculates the output
\eqn{y=f(x)} of a given input \eqn{x}. In doing so, all intermediate
values are stored in the individual torch modules from \code{modules_list}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{self(x,
     channels_first = TRUE,
     save_input = FALSE,
     save_preactivation = FALSE,
     save_output = FAlSE,
     save_last_layer = FALSE)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{

\describe{
\item{\code{x}}{The input torch tensor for this model.}
\item{\code{channels_first}}{If the input tensor \code{x} is given in the format
'channels first', use \code{TRUE}. Otherwise, if the channels are last,
use \code{FALSE} and the input will be transformed into the format 'channels
first'. Default: \code{TRUE}.}
\item{\code{save_input}}{Logical value whether the inputs from each layer
are to be saved or not. Default: \code{FALSE}.}
\item{\code{save_preactivation}}{Logical value whether the preactivations
from each layer are to be saved or not. Default: \code{FALSE}.}
\item{\code{save_output}}{Logical value whether the outputs from each layer
are to be saved or not. Default: \code{FALSE}.}
\item{\code{save_last_layer}}{Logical value whether the inputs,
preactivations and outputs from the last layer are to be saved or not.
Default: \code{FALSE}.}
}
}

\subsection{Return}{

Returns a list of the output values of the model with respect to the
given inputs.
}
}

\section{Method \code{update_ref()}}{


This method updates the intermediate values in each module from the
list \code{modules_list} for the reference input \code{x_ref} and returns the
output from it in the same way as in the \code{forward} method.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{self$update_ref(x_ref,
                channels_first = TRUE,
                save_input = FALSE,
                save_preactivation = FALSE,
                save_output = FAlSE,
                save_last_layer = FALSE)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{

\describe{
\item{\code{x_ref}}{Reference input of the model.}
\item{\code{channels_first}}{If the tensor \code{x_ref} is given in the format
'channels first' use \code{TRUE}. Otherwise, if the channels are last,
use \code{FALSE} and the input will be transformed into the format 'channels
first'. Default: \code{TRUE}.}
\item{\code{save_input}}{Logical value whether the inputs from each layer
are to be saved or not. Default: \code{FALSE}.}
\item{\code{save_preactivation}}{Logical value whether the preactivations
from each layer are to be saved or not. Default: \code{FALSE}.}
\item{\code{save_output}}{Logical value whether the outputs from each layer
are to be saved or not. Default: \code{FALSE}.}
\item{\code{save_last_layer}}{Logical value whether the inputs,
preactivations and outputs from the last layer are to be saved or not.
Default: \code{FALSE}.}
}
}

\subsection{Return}{

Returns a list of the output values of the model with respect to the
given reference input.
}
}

\section{Method \code{set_dtype()}}{


This method changes the data type for all the layers in \code{modules_list}.
Use either \code{'float'} for \link[torch:torch_dtype]{torch::torch_float} or \code{'double'} for
\link[torch:torch_dtype]{torch::torch_double}.
\subsection{Usage}{

\code{self$set_dtype(dtype)}
}

\subsection{Arguments}{

\describe{
\item{\code{dtype}}{The data type for all the calculations and defined
tensors.}
}
}
}

