% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{subset_initialization}
\alias{subset_initialization}
\title{Subset initialization}
\usage{
subset_initialization(
  x,
  arg = "data",
  by_row = TRUE,
  how = "random",
  prop = 0.5,
  ind_ign = integer(),
  kmeans_arg = list(centers = 2),
  initialization = random_initialization(),
  ncores = getOption("ino_ncores"),
  verbose = getOption("ino_progress"),
  label = paste0("subset(", how, ",", prop, ")")
)
}
\arguments{
\item{x}{An object of class \code{ino}.}

\item{arg}{A character, the name of the argument to be subsetted.
Only an argument of class \code{matrix} or \code{data.frame} can be chosen.
Per default, \code{arg = "data"}.}

\item{by_row}{A boolean, set to \code{TRUE} (the default) to subset by row, set to
\code{FALSE} to subset by column.}

\item{how}{A character, specifying how to select the subset.
Can be one of \code{"random"} (default), \code{"first"}, and \code{"kmeans"}.}

\item{prop}{A numeric between 0 and 1, specifying the proportion of the subset.}

\item{ind_ign}{A numeric vector of column indices (or row indices if \code{by_row = FALSE})
that are ignored when clustering.
Only relevant if \code{how = "kmeans"}.}

\item{kmeans_arg}{A list of additional arguments for \code{\link[stats]{kmeans}}.
Per default, \code{kmeans_arg = list(centers = 2)}, which sets the number of
clusters to 2.
Only relevant if \code{how = "kmeans"}.}

\item{initialization}{An object of class \code{strategy_call} which determines the initialization.
The \code{strategy_call} can be generated by one of the strategy functions
(any function with the name \code{*_initialization}), when the \code{x}
argument is unspecified.
Per default, \code{initialization = random_initialization()}, i.e. random
initialization.}

\item{ncores}{The number of cores for parallel computation over parameters and optimizers.
The default is \code{getOption("ino_ncores")}, which is set to \code{1}
when the package is loaded.}

\item{verbose}{A boolean, which indicates whether progress should be printed.
Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.
The default is \code{getOption("ino_progress")}, which is set to \code{TRUE}
when the package is loaded.}

\item{label}{A character, the label for the initialization strategy.}
}
\value{
The updated \code{ino} object.
}
\description{
This function is an implementation of the subset initialization strategy.
}
\keyword{strategy}
