% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_freqWordCor.R
\name{getMostFreqWordCor}
\alias{getMostFreqWordCor}
\title{Test for correlation between the most frequent words.}
\usage{
getMostFreqWordCor(wordF, numWords, getPlot = c(TRUE, TRUE),
  getTextSink = TRUE, mwidth = 1024, mheight = 1024,
  formatType = "png")
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{numWords}{The number of words to be returned.}

\item{getPlot}{A vector with two logical values. If \code{plots[1]==TRUE},
an image of the correlation matrix is saved in the RESULTS directory.
If \code{plots[2]==TRUE}, the image of the p-value matrix associated
with the correlation is saved in the RESULTS directory.}

\item{getTextSink}{If \code{TRUE}, save the correlation matrix and the
associated p-values in a text file in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}
}
\value{
A list with the correlation matrix and the p-value matrix.
}
\description{
Test for correlation between the most frequent words.
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), 
  excludeSW = FALSE)
file.remove(list.files(full.names = TRUE, 
  path = paste0(getwd(), "/RESULTS"), pattern = "loremIpsum"))
getMostFreqWordCor(wordF = wordOccuDF, numWords = 5)
}
