% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formFilters.R
\name{formFilters}
\alias{formFilters}
\alias{formFilterNonderivativeTransactions}
\alias{formFilterDerivativeTransactions}
\alias{formFilterNonderivativeHoldings}
\alias{formFilterDerivativeHoldings}
\title{formFilters}
\usage{
formFilterNonderivativeTransactions(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords,
  transactionType
)

formFilterDerivativeTransactions(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords,
  transactionType
)

formFilterNonderivativeHoldings(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords
)

formFilterDerivativeHoldings(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords
)
}
\arguments{
\item{filing}{The object containing the Form 4 text}

\item{footnoteKeywords}{The character vector containing any specified key
words to be searched in the form's footnotes. Default is NA.}

\item{issuerKeywords}{The character vector containing any specified key
words to be searched within the issuer block. Default is NA.}

\item{issuerTradingSymbol}{The character vector containing any specified
stock tickers. Default is NA.}

\item{rptOwnerKeywords}{The character vector contianing any specified key
words to be searched within the rptOwner block. Default is NA.}

\item{transactionType}{The character vector containing any specified
transaction codes. Default is NA.}
}
\value{
An integer value that if greater than 0, reflects that at the one of
the criteria parameters listed above has been met. The form will then be
parsed further. Otherwise, if the integer value is 0, the function pulls in
the next Form 4 to evaluate.
}
\description{
formFilters
}
\note{
\code{formFilterNonderivativeTransactions} parses the form and
returns an integer value greater than 0 if one of the key word
criteras is met. This function is specifically for the
\code{\link{nonderivativeTransactionsScrape}} and
\code{\link{nonderivativeTransactionsPullAndScrape}} functions.

\code{formFilterDerivativeTransactions} parses the form and
returns an integer value greater than 0 if one of the key word criteras is
met. This function is specifically for the
\code{\link{derivativeTransactionsScrape}} and
\code{\link{derivativeTransactionsPullAndScrape}} functions. The function
shares the same paramters as
\code{\link{formFilterNonderivativeTransactions}} (filing,
footnoteKeywords, issuerKeywords, issuerTradingSymbol, rptOwnerKeywords,
transactionType). The only difference is within the parsing commands which
use the key word derivative rather than nonderivative.

\code{formFilterNonderivativeHoldings} parses the form and
returns an integer value greater than 0 if one of the key word criteras is
met. This function is specifically for the
\code{\link{nonderivativeHoldingsScrape}} and
\code{\link{nonderivativeHoldingsPullAndScrape}} functions. The function
shares the same paramters as
\code{\link{formFilterNonderivativeTransactions}} (filing,
footnoteKeywords, issuerKeywords, issuerTradingSymbol, rptOwnerKeywords)
except for transactionType since that isn't a criteria for a nonderivative
holdings. Additionally, parsing criteria is different due to targeting
holding information rather than transaction information.

\code{formFilterDerivativeHoldings} parses the form and
returns an integer value greater than 0 if one of the key word criteras is
met. This function is specifically for the
\code{\link{derivativeHoldingsScrape}} and
\code{\link{derivativeHoldingsPullAndScrape}} functions. The function
shares the same paramters as
\code{\link{formFilterNonderivativeHoldings}} (filing,
footnoteKeywords, issuerKeywords, issuerTradingSymbol, rptOwnerKeywords)
except for transactionType since that isn't a criteria for a derivative
holdings. The only difference is within the parsing commands which
use the key word derivative rather than nonderivative.
}
