% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_datagrid.R
\name{get_datagrid}
\alias{get_datagrid}
\alias{get_datagrid.data.frame}
\alias{get_datagrid.numeric}
\alias{get_datagrid.factor}
\alias{get_datagrid.default}
\title{Create a reference grid}
\usage{
get_datagrid(x, ...)

\method{get_datagrid}{data.frame}(
  x,
  at = "all",
  factors = "reference",
  numerics = "mean",
  preserve_range = FALSE,
  reference = x,
  ...
)

\method{get_datagrid}{numeric}(x, length = 10, range = "range", ...)

\method{get_datagrid}{factor}(x, ...)

\method{get_datagrid}{default}(
  x,
  at = "all",
  factors = "reference",
  numerics = "mean",
  preserve_range = TRUE,
  reference = x,
  include_smooth = TRUE,
  include_random = FALSE,
  include_response = FALSE,
  data = NULL,
  ...
)
}
\arguments{
\item{x}{An object from which to construct the reference grid.}

\item{...}{Arguments passed to or from other methods (for instance, \code{length} or \code{range} to control the spread of numeric variables.).}

\item{at}{Can be "all" or list of characters indicating columns of interest. Can also contain assignments (as named list, e.g. \code{at = list(c(Sepal.Length = c(2, 4), Species = "setosa"))}, or as string, e.g. \code{at = "Sepal.Length = 2"} or \code{at = c("Sepal.Length = 2", "Species = 'setosa'")} - note the usage of single and double quotes to assign strings within strings). The remaining variables will be fixed.}

\item{factors}{Type of summary for factors. Can be \code{"reference"} (set at the reference level), \code{"mode"} (set at the most common level) or \code{"all"} to keep all levels.}

\item{numerics}{Type of summary for numeric values. Can be \code{"all"} (will duplicate the grid for all unique values), any function (\code{"mean"}, \code{"median"}, ...) or a value (e.g., \code{numerics = 0}).}

\item{preserve_range}{In the case of combinations between numeric variables and factors, setting \code{preserve_range = TRUE} will drop the observations where the value of the numeric variable is originally not present in the range of its factor level. This leads to an unbalanced grid. Also, if you want the minimum and the maximum to closely match the actual ranges, you should increase the \code{length} argument.}

\item{reference}{The reference vector from which to compute the mean and SD.}

\item{length}{Length of numeric \code{"at"} variables.}

\item{range}{Can be one of \code{"range"}, \code{"iqr"}, \code{"ci"}, \code{"hdi"} or \code{"eti"}. If \code{"range"} (default), will use the minimum and maximun of the original vector as end-points. If any other interval, will spread within the range (the default CI width is \verb{95\%} but this can be changed by setting something else, e.g., \code{ci = 0.90}). See \code{\link[=IQR]{IQR()}} and \code{\link[bayestestR:ci]{bayestestR::ci()}}.}

\item{include_smooth}{If \code{x} is a model object, decide whether smooth terms should be included in the data grid or not.}

\item{include_random}{If \code{x} is a mixed model object, decide whether random effect terms should be included in the data grid or not. If \code{include_random} is \code{FALSE}, but \code{x} is a mixed model with random effects, these will still be included in the returned grid, but set to their "population level" value (e.g., \code{NA} for \emph{glmmTMB} or \code{0} for \emph{merMod}). This ensures that common \code{predict()} methods work properly, as these usually need data with all variables in the model included.}

\item{include_response}{If \code{x} is a model object, decide whether the response variable should be included in the data grid or not.}

\item{data}{Optional, the data frame that was used to fit the model. Usually, the data is retrieved via \code{get_data()}.}
}
\value{
Reference grid data frame.
}
\description{
Create a reference matrix, useful for visualisation, with evenly spread and combined values.
}
\examples{
# Add one row to change the "mode" of Species
data <- rbind(iris, iris[149, ], make.row.names = FALSE)

# Single variable is of interest; all others are "fixed"
get_datagrid(data, at = "Sepal.Length")
get_datagrid(data, at = "Sepal.Length", length = 3)
get_datagrid(data, at = "Sepal.Length", range = "ci", ci = 0.90)
get_datagrid(data, at = "Sepal.Length", factors = "mode")

# Multiple variables are of interest, creating a combination
get_datagrid(data, at = c("Sepal.Length", "Species"), length = 3)
get_datagrid(data, at = c(1, 3), length = 3)
get_datagrid(data, at = c("Sepal.Length", "Species"), preserve_range = TRUE)
get_datagrid(data, at = c("Sepal.Length", "Species"), numerics = 0)
get_datagrid(data, at = c("Sepal.Length = 3", "Species"))
get_datagrid(data, at = c("Sepal.Length = c(3, 1)", "Species = 'setosa'"))

# with list-style at-argument
get_datagrid(data, at = list(Sepal.Length = c(1, 3), Species = "setosa"))
}
