% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters.R
\name{get_parameters}
\alias{get_parameters}
\alias{get_parameters.gam}
\alias{get_parameters.vgam}
\alias{get_parameters.Gam}
\alias{get_parameters.zeroinfl}
\alias{get_parameters.gamm}
\alias{get_parameters.hurdle}
\alias{get_parameters.coxme}
\alias{get_parameters.merMod}
\alias{get_parameters.rlmerMod}
\alias{get_parameters.mixed}
\alias{get_parameters.lme}
\alias{get_parameters.MixMod}
\alias{get_parameters.glmmTMB}
\alias{get_parameters.brmsfit}
\alias{get_parameters.stanreg}
\alias{get_parameters.stanmvreg}
\title{Get model parameters}
\usage{
get_parameters(x, ...)

\method{get_parameters}{gam}(x, component = c("all", "conditional",
  "smooth_terms"), ...)

\method{get_parameters}{vgam}(x, component = c("all", "conditional",
  "smooth_terms"), ...)

\method{get_parameters}{Gam}(x, component = c("all", "conditional",
  "smooth_terms"), ...)

\method{get_parameters}{zeroinfl}(x, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{get_parameters}{gamm}(x, component = c("all", "conditional",
  "smooth_terms"), ...)

\method{get_parameters}{hurdle}(x, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{get_parameters}{coxme}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{merMod}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{rlmerMod}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{mixed}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{lme}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{MixMod}(x, effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated",
  "dispersion"), ...)

\method{get_parameters}{glmmTMB}(x, effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated",
  "dispersion"), ...)

\method{get_parameters}{brmsfit}(x, effects = c("fixed", "random",
  "all"), component = c("all", "conditional", "zi", "zero_inflated",
  "dispersion", "simplex", "smooth_terms"), parameters = NULL, ...)

\method{get_parameters}{stanreg}(x, effects = c("fixed", "random",
  "all"), parameters = NULL, ...)

\method{get_parameters}{stanmvreg}(x, effects = c("fixed", "random",
  "all"), parameters = NULL, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated.}

\item{effects}{Should variables for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned.}
}
\value{
\itemize{
  \item for non-Bayesian models and if \code{effects = "fixed"}, a data frame with two columns: the parameter names and the related point estimates
  \item if \code{effects = "random"}, a list of data frames with the random effects (as returned by \code{ranef()}
  \item for Bayesian models, the posterior samples from the requested parameters as data frame.
  \item for Anova (\code{aov()}) with error term, a list of parameters for the conditional, the within-subject and the between-subjects parameters
  \item for models with smooth terms or zero-inflation component, a data frame with three columns: the parameter names, the related point estimates and the component
}
}
\description{
Returns the point estimates (or posterior samples for Bayesian
   models) from a model.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
