% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.interep.R
\name{cv.interep}
\alias{cv.interep}
\title{This function does k-fold cross-validation for interep and returns the optimal value of lambda.}
\usage{
cv.interep(e, z, y, response = "continuous", initiation = NULL,
  alpha.i = 1, lambda1, lambda2, nfolds, maxits = 30, corre)
}
\arguments{
\item{e}{matrix of environment factors.}

\item{z}{matrix of omics factors. In the case study, the omics measurements are lipidomics data.}

\item{y}{the longitudinal response.}

\item{response}{type of the longitudinal response, the default is continuous.}

\item{initiation}{the method for iniating the coefficient vector.  The default is lasso.}

\item{alpha.i}{the elastic-net mixing parameter.  The program adopts the elastic-net to choose initial values of the coefficient vector.
alpha.i is the elastic-net mixing parameter, with 0 \eqn{\le} alpha.i \eqn{\le} 1.  alpha.i=1 is the lasso penalty, and alpha.i=0 is the ridge penalty.
The default is 1.  If the user chooses a method other than elastic-net to initialize coefficients, alpha.i will be ignored.}

\item{lambda1}{a user-supplied sequence of \eqn{\lambda_{1}} values, which serves as a tuning parameter for individual predictors.}

\item{lambda2}{a user-supplied sequence of \eqn{\lambda_{2}} values, which serves as a tuning parameter for interactions.}

\item{nfolds}{the number of folds for cross-validation.}

\item{maxits}{the maximum number of iterations that is used in the estimation algorithm.  The default value is 30.}

\item{corre}{the working correlation structure that is used in the estimation algorithm. interep provides three choices for the
working correlation structure: "AR-1", "independece" and "exchangeable".}
}
\value{
an object of class "cv.interep" is returned, which is a list with components:
\item{lam1}{the optimal \eqn{\lambda_{1}}.}
\item{lam2}{the optimal \eqn{\lambda_{2}}.}
}
\description{
This function does k-fold cross-validation for interep and returns the optimal value of lambda.
}
\details{
When dealing with predictors with both main effects and interactions, this function returns two optimal tuning parameters,
\eqn{\lambda_{1}} and \eqn{\lambda_{2}}; when there are only main effects in the predictors, this function returns \eqn{\lambda_{1}},
which is the optimal tuning parameter for individual predictors containing main effects.
}
\references{
Zhou, F., Wang, W., Jiang, Y. and Wu, C. (2018+). Variable selection for interactions in longitudinal lipidomics studies.

Wu, C., Zhong, P. & Cui, Y. (2018). Additive varying-coefficient model for nonlinear gene-environment interactions.
\href{https://doi.org/10.1515/sagmb-2017-0008}{\emph{Statistical Applications in Genetics and Molecular Biology}, 17(2)}

Wu, C., Jiang, Y., Ren, J., Cui, Y. and Ma, S. (2018). Dissecting gene-environment interactions: a penalized robust approach accounting for hierarchical structures.
\href{https://doi.org/10.1002/sim.7518}{\emph{Statistics in Medicine}, 37:437–456}

Wu, C., Shi, X., Cui, Y. and Ma, S. (2015) A penalized robust semiparametric approach for gene-environment interactions.
\href{https://doi.org/10.1002/sim.6609}{\emph{Statistics in Medicine}, 34 (30): 4016–4030}

Wu, C., Cui, Y. and Ma, S. (2014) Integrative analysis of gene-environment interactions under a multi-response partially linear varying coefficient model.
\href{https://doi.org/10.1002/sim.6287}{\emph{Statistics in Medicine}, 33 (28): 4988–4498}

Wu, C. and Cui Y. (2013) A novel method for identifying nonlinear gene-environment interactions in case-control association studies.
\href{https://doi.org/10.1007/s00439-013-1350-z}{\emph{Human Genetics}, 132 (12): 1413–1425}
}
