% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary.R
\name{binary}
\alias{binary}
\alias{as_binary}
\alias{from_binary}
\title{Represent address as binary}
\usage{
as_binary(ip)

from_binary(bits)
}
\arguments{
\item{ip}{An \code{\link{ip_address}} vector}

\item{bits}{A character vector containing only \code{0} and \code{1} characters}
}
\value{
\itemize{
\item \code{as_binary()} returns a character vector
\item \code{from_binary()} returns an \code{\link{ip_address}} vector
}
}
\description{
\code{as_binary()} and \code{from_binary()} encode and decode an \code{\link{ip_address}}
vector to a character vector of bits.
}
\details{
The bits are stored in network order (also known as big-endian order), which
is part of the IP standard.

IPv4 addresses use 32 bits, IPv6 addresses use 128 bits, and missing values
are encoded as \code{NA}.
}
\examples{
x <- ip_address(c("192.168.0.1", "2001:db8::8a2e:370:7334", NA))
as_binary(x)

from_binary(as_binary(x))
}
\seealso{
Use \code{as_packed()} and \code{from_packed()} to encode/decode raw bytes.
}
