% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_logistic.R
\name{ppi_logistic}
\alias{ppi_logistic}
\title{PPI Logistic Regression}
\usage{
ppi_logistic(X_l, Y_l, f_l, X_u, f_u, opts = NULL)
}
\arguments{
\item{X_l}{(matrix): n x p matrix of covariates in the labeled data.}

\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{X_u}{(matrix): N x p matrix of covariates in the unlabeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{opts}{(list, optional): Options to pass to the optimizer.
See ?optim for details.}
}
\value{
(list): A list containing the following:

\describe{
\item{est}{(vector): vector of PPI logistic regression coefficient
estimates.}
\item{se}{(vector): vector of standard errors of the coefficients.}
\item{rectifier_est}{(vector): vector of the rectifier logistic
regression coefficient estimates.}
\item{var_u}{(matrix): covariance matrix for the gradients in the
unlabeled data.}
\item{var_l}{(matrix): covariance matrix for the gradients in the
labeled data.}
\item{grads}{(matrix): matrix of gradients for the
labeled data.}
\item{grads_hat_unlabeled}{(matrix): matrix of predicted gradients for
the unlabeled data.}
\item{grads_hat}{(matrix): matrix of predicted gradients for the
labeled data.}
\item{inv_hessian}{(matrix): inverse Hessian matrix.}
}
}
\description{
Helper function for PPI logistic regression
}
\details{
Prediction Powered Inference (Angelopoulos et al., 2023)
\url{https://www.science.org/doi/10.1126/science.adi6000}
}
\examples{

dat <- simdat(model = "logistic")

form <- Y - f ~ X1

X_l <- model.matrix(form, data = dat[dat$set == "labeled",])

Y_l <- dat[dat$set == "labeled", all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set == "labeled", all.vars(form)[2]] |> matrix(ncol = 1)

X_u <- model.matrix(form, data = dat[dat$set == "unlabeled",])

f_u <- dat[dat$set == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

ppi_logistic(X_l, Y_l, f_l, X_u, f_u)

}
