% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rectified_p_value}
\alias{rectified_p_value}
\title{Rectified P-Value}
\usage{
rectified_p_value(
  rectifier,
  rectifier_std,
  imputed_mean,
  imputed_std,
  null = 0,
  alternative = "two-sided"
)
}
\arguments{
\item{rectifier}{(float or vector): Rectifier value.}

\item{rectifier_std}{(float or vector): Rectifier standard deviation.}

\item{imputed_mean}{(float or vector): Imputed mean.}

\item{imputed_std}{(float or vector): Imputed standard deviation.}

\item{null}{(float, optional): Value of the null hypothesis to be tested.
Defaults to \code{0}.}

\item{alternative}{(str, optional): Alternative hypothesis, either
'two-sided', 'larger' or 'smaller'.}
}
\value{
(float or vector): The rectified p-value.
}
\description{
Computes a rectified p-value.
}
\examples{

rectifier <- 0.7

rectifier_std <- 0.5

imputed_mean <- 1.5

imputed_std <- 0.3

rectified_p_value(rectifier, rectifier_std, imputed_mean, imputed_std)

}
