% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfTransform}
\alias{ipfTransform}
\title{Transform function}
\usage{
ipfTransform(data, trans = "positive", minRSSI = -104, maxRSSI = 0,
  noRSSI = 0, alpha = 24)
}
\arguments{
\item{data}{a vector, matrix or data frame containing the RSSI vectors}

\item{trans}{the transformations to perform}

\item{minRSSI}{the minimum value for RSSI to consider when transforming
the RSSI to positive values.}

\item{maxRSSI}{the maximum value for RSSI to consider when transforming
the RSSI to exponential values.}

\item{noRSSI}{value used in the RSSI data to represent a not detected AP.}

\item{alpha}{parameter for exponential transformation}
}
\value{
This function returns a vector, matrix or data frame containing
        the transformed data
}
\description{
This function transforms the RSSI data to positive
or exponential values
}
\examples{
    trainRSSI <- ipftrain[,1:168]
    ipfTransform(trainRSSI, trans = 'positive')

    trainRSSI <- ipftrain[,1:168]
    posTrainRSSI <- ipfTransform(trainRSSI, trans = 'positive')
    expTrainRSSI <- ipfTransform(posTrainRSSI, trans = 'exponential', maxRSSI = 104)

}

