% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{ipums_data_collections}
\alias{ipums_data_collections}
\title{List IPUMS data collections}
\usage{
ipums_data_collections()
}
\value{
A \code{\link[tibble:tbl_df-class]{tibble}} with three columns containing the
full collection name, the corresponding code used by the IPUMS API, and the
status of API support for the collection.
}
\description{
List IPUMS data collections with corresponding codes used by the IPUMS API.
Note that some data collections do not yet have API support. For an overview
of ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
# Print a tibble of all IPUMS data collections:
ipums_data_collections()
}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
