% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_test.R
\name{boxplot_test}
\alias{boxplot_test}
\title{Box Plot Testing Performance}
\usage{
boxplot_test(irace_results, type = c("all", "ibest", "best"), ...)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{type}{String, (default \code{"all"}) possible values are \code{"all"}, "ibest" or "best". "all" shows all the configurations included in the test, "best" shows the elite configurations of the last iteration and "ibest" shows the elite configurations of each iteration (requires that irace includes the iteration elites in the testing).}

\item{...}{Other arguments passed to \code{\link[=boxplot_performance]{boxplot_performance()}}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} boxplot object
}
\description{
Creates a box plot that displays the performance of a set of configurations on the test instances.
}
\details{
The performance data is obtained from the test evaluations performed
by irace. Note that the testing is not a default feature in irace and should
be enabled in the setup (see the irace package user guide for more details).
}
\examples{
iraceResults <- read_logfile(system.file(package="iraceplot", "exdata",
                                         "guide-example.Rdata", mustWork = TRUE))
boxplot_test(iraceResults)
}
\seealso{
\code{\link[=boxplot_training]{boxplot_training()}} \code{\link[=boxplot_performance]{boxplot_performance()}}
}
