% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isatools.R
\name{isa_rows_add}
\alias{isa_rows_add}
\title{Add sample rows to an isatab}
\usage{
isa_rows_add(x, n, total = FALSE, replicate = TRUE)
}
\arguments{
\item{x}{an isatab object}

\item{n}{number of rows to add}

\item{total}{if TRUE, the resulting isatab object will have \code{n} rows.}

\item{replicate}{If true (default), the values in the last row of the isatabs will be replicated.
Otherwise, empty rows will be added.}
}
\value{
An object of class isatab with expanded rows
}
\description{
Add sample rows to an isatab
}
\details{
Expand the isatab by adding rows. If \code{total} parameter is \code{TRUE}, the
number of rows to be added will be such that the final number of rows is
\code{n}. However, if \code{n} is smaller than current number of rows, no rows
will be removed.
}
\examples{
file <- system.file('extdata', 's_isatab.txt', package='isaeditor')
isa_s <- read_isa(file)
isa_new <- isa_rows_add(isa_s, 10, total=TRUE)
n_row(isa_new)
}
\seealso{
\code{\linkS4class{isatab}}
}
