% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{a_A_B}
\alias{a_A_B}
\title{Isotope fractionation factor between A and B}
\usage{
a_A_B(A, B)
}
\arguments{
\item{A}{Isotope delta value of A (‰).}

\item{B}{Isotope delta value of B (‰).}
}
\value{
Returns the isotope fractionation factor.
}
\description{
\code{a_A_B()} calculates the isotope fractionation factor.
}
\details{
\deqn{\alpha^{i}E_{A/B} =
\frac{\delta^{i}E_{A} + 1}{\delta^{i}E_{B} + 1}}
}
\examples{
a_A_B(A = 10, B = 12)

}
\seealso{
\code{\link[=A_from_a]{A_from_a()}} calculates the isotope delta value of A.

\code{\link[=B_from_a]{B_from_a()}} calculates the isotope delta value of B.

Other fractionation_factors: 
\code{\link{a13_CO2g_CO2aq}()},
\code{\link{a18_CO2acid_c}()},
\code{\link{a18_CO2aq_H2O}()},
\code{\link{a18_CO2g_H2O}()},
\code{\link{a18_CO3_H2O}()},
\code{\link{a18_H2O_OH}()},
\code{\link{a18_HCO3_H2O}()},
\code{\link{a18_c_H2O}()}
}
\concept{fractionation_factors}
