% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_info_operations.R
\name{iso_rename_file_info}
\alias{iso_rename_file_info}
\title{Rename file info columns}
\usage{
iso_rename_file_info(
  iso_files,
  ...,
  file_specific = FALSE,
  quiet = default(quiet)
)
}
\arguments{
\item{iso_files}{collection of iso_file objects}

\item{...}{dplyr-style \link[dplyr]{rename} conditions applied based on each file's file_info (see \code{\link{iso_get_file_info}})}

\item{file_specific}{whether to run the select criteria (\code{...}) specifically within each individual file rather than on all files jointly. This is a lot slower but makes it possible to  select different columns in different iso_files depending on what exists in each file and is mostly of use when working with data from multiple instruments.}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_message_on} and \link[=iso_info_messages]{iso_turn_info_message_off}}
}
\description{
Rename file info columns (\code{\link{iso_get_file_info}}) within isofile objects. Works just like dplyr's \link[dplyr]{rename}. You can also use \link[dplyr]{rename} directly but it will not provide summary information on the operation. To select specific columns to keep (discarding all others), use \link{iso_select_file_info} instead. Set \code{file_specific = TRUE} to rename different columns in different iso_files depending on what exists in each file. This is very useful when working with data from multiple instruments that may have the same information (e.g. sample name) stored in different columns.
}
\seealso{
Other file_info operations: 
\code{\link{iso_add_file_info.iso_file_list}()},
\code{\link{iso_filter_files}()},
\code{\link{iso_mutate_file_info}()},
\code{\link{iso_parse_file_info}()},
\code{\link{iso_select_file_info}()},
\code{\link{iso_set_file_root}()}
}
\concept{file_info operations}
