% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itpPlot.R
\name{plot.itp}
\alias{plot.itp}
\title{Plot method for objects of class \code{"itp"}}
\usage{
\method{plot}{itp}(x, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"itp"}, a result of a
call to \code{\link{itp}}.}

\item{...}{Arguments passed to \code{\link[graphics]{curve}},
such as graphical parameters.}
}
\value{
No return value, only the plot is produced.
}
\description{
Plot method for objects of class \code{"itp"} returned from
\code{\link{itp}}.
}
\details{
Uses \code{\link[graphics]{curve}} to produce a plot of the
  function \code{f} provided to \code{\link{itp}} over the interval within
  which a root was sought. The estimated root is indicated using a
  horizontal line drawn at 0 and a vertical line drawn at the estimated
  root. By default the name of the function \code{f} is used as a title,
  but this can be replaced by supplying the argument \code{main}.  The
  interval over which \code{f} is plotted can be changed by supplying the
  arguments \code{from} and/or \code{to}.
}
\examples{
# Lambert

# Supplying an R function
lambert <- function(x) x * exp(x) - 1
x <- itp(lambert, c(-1, 1))
plot(x)

# Supplying an external pointer to a C++ function
lambert_ptr <- xptr_create("lambert")
x <- itp(lambert_ptr, c(-1, 1))
plot(x, main = "Lambert")
}
\seealso{
\code{\link{itp}} for the Interpolate, Truncate, Project (ITP) root
  finding algorithm.
}
