% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{add_bars}
\alias{add_bars}
\title{Adding bars to an existing plot.}
\usage{
add_bars(x, y, y0 = NULL, width = 1, horiz = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector with x-positions of bars.}

\item{y}{Numeric vector with height of the bars.}

\item{y0}{Optional numeric value or vector with the onset(s) of the bars. 
When \code{y0} is not specified, the lowest value of the y-axis is used.}

\item{width}{Numeric value, determining the width of the bars in units of 
the x-axis.}

\item{horiz}{Logical value: whether or not to plot horizontal bars. 
Defaults to FALSE.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\description{
Adding bars to an existing plot.
}
\examples{
data(simdat)

# averages per condition:
subj <- with(simdat, aggregate(Y, 
    list(Group=Group, Condition=Condition, Subject=Subject), mean))
avg  <- with(subj, tapply(x, list(Group, Condition), mean))
ses  <- with(subj, tapply(x, list(Group, Condition), se))

# barplot of Adults:
b <- barplot(avg['Adults',], beside=TRUE)
# overlay addbars:
add_bars(b, avg['Children',], density=25)

# or some variants:
b <- barplot(avg['Adults',], beside=TRUE)
add_bars(b+.1, avg['Children',], col=alpha('red'))

# also the option to make your own type of plot:
emptyPlot(c(-10,10), c(-2,5), v0=0, ylab="Condition")
add_bars(-1*avg["Children",], -1:4, y0=0, col=alpha("blue"), 
    border="blue", horiz=TRUE)
add_bars(avg["Adults",], -1:4, y0=0, col=alpha("black"), 
    border=1, horiz=TRUE, xpd=TRUE)
mtext(c("Children", "Adults"), side=3, at=c(-5,5), line=1, cex=1.25, font=2)

}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fadeRug}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}, \code{\link{rug_model}}
}

