% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getsiv.R
\name{ivgets}
\alias{ivgets}
\title{General-to-specific modeling for 2SLS models}
\usage{
ivgets(
  formula,
  data,
  gum.result = NULL,
  t.pval = 0.05,
  wald.pval = t.pval,
  do.pet = TRUE,
  ar.LjungB = NULL,
  arch.LjungB = NULL,
  normality.JarqueB = NULL,
  include.gum = FALSE,
  include.1cut = FALSE,
  include.empty = FALSE,
  max.paths = NULL,
  turbo = FALSE,
  tol = 1e-07,
  max.regs = NULL,
  print.searchinfo = TRUE,
  alarm = FALSE,
  keep_exog = NULL,
  overid = NULL,
  weak = NULL
)
}
\arguments{
\item{formula}{A formula in the format \code{y ~ x1 + x2 | z1 + z2}.}

\item{data}{A data frame with all necessary variables y, x, and z.}

\item{gum.result}{a \code{list} with the estimation results of the General Unrestricted Model (GUM), or \code{NULL} (default). If the estimation results of the GUM are already available, then re-estimation of the GUM is skipped if the estimation results are provided via this argument}

\item{t.pval}{\code{numeric} value between 0 and 1. The significance level used for the two-sided regressor significance t-tests }

\item{wald.pval}{\code{numeric} value between 0 and 1. The significance level used for the Parsimonious Encompassing Tests (PETs) }

\item{do.pet}{\code{logical}. If \code{TRUE} (default), then a Parsimonious Encompassing Test (PET) against the GUM is undertaken at each regressor removal for the joint significance of all the deleted regressors along the current path. If \code{FALSE}, then a PET is not undertaken at each regressor removal}

\item{ar.LjungB}{a two element \code{vector} or \code{NULL} (default). In the former case, the first element contains the AR-order, the second element the significance level. If \code{NULL}, then a test for autocorrelation is not conducted}

\item{arch.LjungB}{a two element \code{vector} or \code{NULL} (default). In the former case, the first element contains the ARCH-order, the second element the significance level. If \code{NULL}, then a test for ARCH is not conducted}

\item{normality.JarqueB}{\code{NULL} or a \code{numeric} value between 0 and 1. In the latter case, a test for non-normality is conducted using a significance level equal to \code{normality.JarqueB}. If \code{NULL}, then no test for non-normality is conducted}

\item{include.gum}{\code{logical}. If \code{TRUE}, then the GUM (i.e. the starting model) is included among the terminal models. If \code{FALSE} (default), then the GUM is not included}

\item{include.1cut}{\code{logical}. If \code{TRUE}, then the 1-cut model is added to the list of terminal models. If \code{FALSE} (default), then the 1-cut is not added, unless it is a terminal model in one of the paths }

\item{include.empty}{\code{logical}. If \code{TRUE}, then the empty model is added to the list of terminal models. If \code{FALSE} (default), then the empty model is not added, unless it is a terminal model in one of the paths }

\item{max.paths}{\code{NULL} (default) or an integer greater than 0. If \code{NULL}, then there is no limit to the number of paths. If an integer (e.g. 1), then this integer constitutes the maximum number of paths searched (e.g. a single path) }

\item{turbo}{\code{logical}. If \code{TRUE}, then (parts of) paths are not searched twice (or more) unnecessarily, thus yielding a significant potential for speed-gain. However, the checking of whether the search has arrived at a point it has already been comes with a slight computational overhead. Accordingly, if \code{turbo=TRUE}, then the total search time might in fact be higher than if \code{turbo=FALSE}. This happens if estimation is very fast, say, less than quarter of a second. Hence the default is \code{FALSE}}

\item{tol}{numeric value (\code{default = 1e-07}). The tolerance for detecting linear dependencies in the columns of the variance-covariance matrix when computing the Wald-statistic used in the Parsimonious Encompassing Tests (PETs), see the \code{\link{qr.solve}} function}

\item{max.regs}{\code{integer}. The maximum number of regressions along a deletion path. Do not alter unless you know what you are doing! }

\item{print.searchinfo}{\code{logical}. If \code{TRUE} (default), then a print is returned whenever simiplification along a new path is started}

\item{alarm}{\code{logical}. If \code{TRUE}, then a sound or beep is emitted (in order to alert the user) when the model selection ends }

\item{keep_exog}{A numeric vector of indices or a character vector of names
corresponding to the exogenous regressors in the \code{data} that should not
be selected over. Default \code{NULL} means that selection is over all
exogenous regressors. If an intercept has been specified in the
\code{formula} but is not already included in the \code{data}, then it can be
kept by either including the index \code{0} or the character
\code{"Intercept"}, respectively, as an element in \code{keep_exog}.}

\item{overid}{\code{NULL} if no Sargan test of overidentifying restrictions
should be used as a diagnostic check for model selection or a numeric value
between 0 and 1. In the latter case, the test is conducted using this value
as the significance level.}

\item{weak}{\code{NULL} if no weak instrument F-test on the first stage
should be used as a diagnostic check for model selection or a numeric value
between 0 and 1. In the latter case, the test is conducted using this value
as the significance level.}
}
\value{
Returns a list of class \code{"ivgets"} with three named elements.
\code{$selection} stores the selection results from
\code{\link[gets]{getsFun}} (including paths, terminal models, and best
specification). \code{$final} stores the \code{\link[ivreg]{ivreg}} model
object of the best specification or \code{NULL} if the GUM does not pass
all diagnostics. \code{$keep} stores the names of the regressors that were
not selected over, including the endogenous regressors, which are always
kept.
}
\description{
General-to-specific modeling for 2SLS models
}
