% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivolcano.R
\name{ivolcano}
\alias{ivolcano}
\title{ivolcano}
\usage{
ivolcano(
  data,
  logFC_col = "logFC",
  pval_col = "adj.P.Val",
  gene_col = "gene",
  title = "Volcano Plot",
  interactive = TRUE,
  onclick_fun = NULL,
  pval_cutoff = 0.05,
  logFC_cutoff = 1,
  top_n = 10,
  label_mode = "separate",
  fontface = "italic",
  label_sig_only = TRUE,
  threshold_line = list(color = "black", linetype = "dashed", linewidth = 0.5),
  sig_colors = c(Up = "red", Down = "blue", Not_Significant = "grey70"),
  size_by = "none"
)
}
\arguments{
\item{data}{A data frame that contains minimal information with gene id, logFC and adjusted P values}

\item{logFC_col}{column name in 'data' that stored the logFC values}

\item{pval_col}{column name in 'data' that stored the adjusted P values}

\item{gene_col}{column name in 'data' that stored the gene IDs}

\item{title}{plot title}

\item{interactive}{whether plot the graph in interactive mode}

\item{onclick_fun}{effects when click on the dot (gene), default is NULL}

\item{pval_cutoff}{cutoff of the adjusted P values}

\item{logFC_cutoff}{cutoff of the logFC values}

\item{top_n}{top N genes to display the labels (gene ID)}

\item{label_mode}{one of 'all' or 'separate' (default).
If label_mode = 'all', top_n genes with minimal p values will be displayed,
otherwise, top_n up-regulated and top_n down-regulated genes will be displayed.}

\item{fontface}{one of 'plain', 'bold', 'italic' (default) and their combination, e.g. 'bold.italic'}

\item{label_sig_only}{whether filter significant genes before subset 'top_n' genes}

\item{threshold_line}{customize threshold line style (e.g., line color, type, and width)}

\item{sig_colors}{customize colors for up- and down-regulated, and non-significant genes}

\item{size_by}{one of "none" (default), "negLogP", or "absLogFC" to scale dot sizes.}
}
\value{
volcano plot
}
\description{
interactive volcano plot
}
\examples{
# example data
f <- system.file('extdata/airway.rds', package='ivolcano')
df <- readRDS(f)
# plot
ivolcano(df,
        logFC_col = "log2FoldChange",
        pval_col = "padj",
        gene_col = "symbol",
        top_n = 5,
        onclick_fun=onclick_genecards)
}
\author{
Guangchuang Yu
}
