% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivx_ar.R
\name{ivx_ar_fit}
\alias{ivx_ar_fit}
\title{Fitter Functions for IVX-AR Models}
\usage{
ivx_ar_fit(
  y,
  x,
  horizon = 1,
  offset = NULL,
  ar = "auto",
  ar_max = 5,
  ar_ic = "bic",
  ar_grid = function(x) seq(x - 0.3, x + 0.3, by = 0.02),
  ...
)
}
\arguments{
\item{y}{vector of observations of length \code{n}, or a matrix with
    \code{n} rows.}

\item{x}{design matrix of dimension \code{n * p}.}

\item{horizon}{is the horizon (default horizon = 1 corresponds to a
short-horizon regression).}

\item{offset}{(numeric of length \code{n}).  This can be used to
    specify an \emph{a priori} known component to be included in the
    linear predictor during fitting.}

\item{ar}{Method to include the autoregressive terms. "auto" find the optimal
ar order by using the information criteria. \code{ar = 0} reduces to simple \code{\link{ivx}}.
\code{ar > 1} uses a fixed order to estimate the model.}

\item{ar_max}{Maximum ar order of model to fit.}

\item{ar_ic}{Information criterion to be used in model selection.}

\item{ar_grid}{The ar grid sequence of which to iterate.}

\item{...}{Further arguments passed to the function which is fitting the best AR model.
If \code{ar = "auto"} then the internal function \code{auto_ar} is used, if \code{ar = "forecast"} then
the the function \code{forecast::auto.arima} is used. If ar is of fixed length then \code{arima} is used.}
}
\description{
Basic function called by \code{ivx_ar} to fit predictive models.
These should only be used directly by experienced users.
}
\examples{

ivx_ar_fit(monthly$Ret, as.matrix(monthly$LTY))

ivx_ar_fit(monthly$Ret, as.matrix(monthly$LTY), ar = 1)

}
