% Generated by roxygen2 (4.0.2): do not edit by hand
\name{addFeature}
\alias{addFeature}
\title{Low level function for adding a new feature to a demographic Model}
\usage{
addFeature(dm, type, parameter = NA, lower.range = NA, upper.range = NA,
  fixed.value = NA, par.new = T, pop.source = NA, pop.sink = NA,
  time.point = NA, group = 0, variance = 0, zero.inflation = 0)
}
\arguments{
\item{dm}{The demographic model to which the feature will be added}

\item{type}{The type of the feature coded as a character}

\item{parameter}{Either the name of the parameter (par.new=TRUE), or an R expression
possibly containing one or more previously created parameter
names.}

\item{lower.range}{The lower boundary for the value of the parameter}

\item{upper.range}{The upper boundary for the value of the parameter}

\item{fixed.value}{If given, the parameter will be set to a fixed value. This
is equivalent to seting lower.range equal to upper.range.}

\item{par.new}{If 'TRUE' a new parameter will be created using the
arguments 'lower.range' and 'upper.range' or
'fixed.value'. It will be named 'parameter'.
If 'FALSE' the argument 'parameter'
will be evaluated instead.}

\item{pop.source}{The source population if availible (think e.g. of migration)}

\item{pop.sink}{The target or "sink" population if availible (think e.g. of migration)}

\item{time.point}{Normally the point in backwards time where the feature
starts.}

\item{group}{For genomic features, different groups can be created.}

\item{variance}{Set to a value different from 0 to introduce variation in the
the parameter value for different loci. The
variation follows a gamma distribution with mean equal to
the value provided as \code{parameter}, and variance as given
here. Can also be set to a previously
created parameter, or an expression based on parameters.}

\item{zero.inflation}{If used, a zero inflated gamma distribution is
used to model the variablility between loci. This parameter
should evluate to the percent of loci for which the parameter
is 0. The values for all other loci will be drawn from the
discretized gamma distribution.}
}
\value{
The extended demographic model.
}
\description{
Use this function to add a feature to a dm if there is no higher level
"dm.add*"-function availible.
}

