% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPP.R
\name{Schur}
\alias{Schur}
\title{Evaluation of Schur polynomial - C++ implementation}
\usage{
Schur(x, lambda)
}
\arguments{
\item{x}{values of the variables, a vector of \code{bigq} numbers, or a
vector that can be coerced as such (e.g. \code{c("2", "5/3")})}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}
}
\value{
A \code{bigq} number.
}
\description{
Evaluates a Schur polynomial. The Schur polynomials are the
  Jack \eqn{P}-polynomials with Jack parameter \eqn{\alpha=1}.
}
\examples{
Schur(c("1", "3/2", "-2/3"), lambda = c(3, 1))
}
