% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_functions.R
\name{vars_functions}
\alias{vars_functions}
\title{Organize higher-level information for creating variants.}
\description{
The following functions organize information that gets passed to \code{create_variants}
to generate variants from a reference genome.
Each function represents a method of generation and starts with \code{"vars_"}.
The first three are phylogenomic methods, and all functions but \code{vars_vcf}
will use molecular evolution information when passed to \code{create_variants}.
}
\details{
\describe{
\item{\code{\link{vars_theta}}}{Uses an estimate for theta, the population-scaled
mutation rate, and a desired number of variants.}
\item{\code{\link{vars_phylo}}}{Uses phylogenetic tree(s) from \code{phylo}
object(s) or NEWICK file(s), one tree per chromosome or one for all
chromosomes.}
\item{\code{\link{vars_gtrees}}}{Uses gene trees, either in the form of
an object from the \code{scrm} or \code{coala} package or
a file containing output in the style of the \code{ms} program.}
\item{\code{\link{vars_ssites}}}{Uses matrices of segregating sites,
either in the form of
\code{scrm} or \code{coala} coalescent-simulator object(s), or
a \code{ms}-style output file.}
\item{\code{\link{vars_vcf}}}{Uses a variant call format (VCF) file that
directly specifies variants.}
}
}
\seealso{
\code{\link{create_variants}}
}
