% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevo.R
\name{indels}
\alias{indels}
\title{Insertions and deletions (indels) specification}
\usage{
indels(rate, max_length = 10, a = NULL, rel_rates = NULL)
}
\arguments{
\item{rate}{Single number specifying the overall indel rate among all lengths.}

\item{max_length}{Maximum length of indels. Defaults to \code{10}.}

\item{a}{Extra parameter necessary for generating rates from a Lavalette distribution.
See Details for more info. Defaults to \code{NULL}.}

\item{rel_rates}{A numeric vector of relative rates for each indel length
from 1 to the maximum length.
If provided, all arguments other than \code{rate} are ignored.
Defaults to \code{NULL}.}
}
\value{
An \code{indel_info} object, which is an R6 class that wraps the info needed for
the \code{create_haplotypes} function.
It does not allow the user to directly manipulate the info inside, as that
should be done using this function.
You can use the \code{rates()} method to view the indel rates by size.
}
\description{
Construct necessary information for insertions and deletions (indels) that will
be used in \code{create_haplotypes}.
}
\details{
All indels require the \code{rate} parameter, which specifies
the overall indels rate among all lengths.
The \code{rate} parameter is ultimately combined with a vector of relative rates among
the different lengths of indels from 1 to the maximum possible length.
There are three different ways to specify/generate relative-rate values.
\enumerate{
\item Assume that rates are proportional to \code{exp(-L)} for indel length
\code{L} from 1 to the maximum length (Albers et al. 2011).
This method will be used if the following arguments are provided:
\itemize{
\item \code{rate}
\item \code{max_length}
}
\item Generate relative rates from a Lavalette distribution
(Fletcher and Yang 2009), where the rate for length \code{L} is proportional to
\code{{L * max_length / (max_length - L + 1)}^(-a)}.
This method will be used if the following arguments are provided:
\itemize{
\item \code{rate}
\item \code{max_length}
\item \code{a}
}
\item Directly specify values by providing a numeric vector of relative
rates for each insertion/deletion length from 1 to the maximum length.
This method will be used if the following arguments are provided:
\itemize{
\item \code{rate}
\item \code{rel_rates}
}
}
}
\examples{
# relative rates are proportional to `exp(-L)` for indel
# length `L` from 1 to 5:
indel_rates1 <- indels(0.1, max_length = 5)

# relative rates are proportional to Lavalette distribution
# for length from 1 to 10:
indel_rates2 <- indels(0.2, max_length = 10, a = 1.1)

# relative rates are all the same for lengths from 1 to 100:
indel_rates3 <- indels(0.2, rel_rates = rep(1, 100))



}
\references{
Albers, C. A., G. Lunter, D. G. MacArthur, G. McVean, W. H. Ouwehand, and R. Durbin.
2011. Dindel: accurate indel calls from short-read data. Genome Research 21:961–973.

Fletcher, W., and Z. Yang. 2009. INDELible: a flexible simulator of
biological sequence evolution. Molecular Biology and Evolution 26:1879–1888.
}
