% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R
\name{ref_genome}
\alias{ref_genome}
\title{R6 Class Representing a Reference Genome}
\description{
Interactive wrapper for a pointer to a C++ object that stores reference genome
information.
}
\details{
This class should NEVER be created using \code{ref_genome$new}.
Only use \code{read_fasta} or \code{create_genome}.
Because this class wraps a pointer to a C++ object, there are no fields to
manipulate directly.
All manipulations are done through this class's methods.
}
\examples{

## ------------------------------------------------
## Method `ref_genome$set_names`
## ------------------------------------------------

ref <- create_genome(4, 10)
ref$set_names(c("a", "b", "c", "d"))


## ------------------------------------------------
## Method `ref_genome$clean_names`
## ------------------------------------------------

ref <- create_genome(4, 10)
ref$set_names(c("a:", "b|", "c;", "d'"))
ref$clean_names()


## ------------------------------------------------
## Method `ref_genome$add_chroms`
## ------------------------------------------------

ref <- create_genome(4, 10)
ref$add_chroms("TCAGTCAG")

## ------------------------------------------------
## Method `ref_genome$rm_chroms`
## ------------------------------------------------

ref <- create_genome(4, 10)
ref$set_names(c("a", "b", "c", "d"))
ref$rm_chroms("b")


## ------------------------------------------------
## Method `ref_genome$merge_chroms`
## ------------------------------------------------

ref <- create_genome(4, 10)
ref$merge_chroms(ref$chrom_names()[1:2])
ref$merge_chroms(NULL)


## ------------------------------------------------
## Method `ref_genome$filter_chroms`
## ------------------------------------------------

ref <- create_genome(4, 100, 50)
ref$filter_chroms(90, "size")
ref$filter_chroms(0.4, "prop")

}
\seealso{
\code{\link{read_fasta}} \code{\link{create_genome}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ref_genome-new}{\code{ref_genome$new()}}
\item \href{#method-ref_genome-print}{\code{ref_genome$print()}}
\item \href{#method-ref_genome-ptr}{\code{ref_genome$ptr()}}
\item \href{#method-ref_genome-n_chroms}{\code{ref_genome$n_chroms()}}
\item \href{#method-ref_genome-sizes}{\code{ref_genome$sizes()}}
\item \href{#method-ref_genome-chrom_names}{\code{ref_genome$chrom_names()}}
\item \href{#method-ref_genome-chrom}{\code{ref_genome$chrom()}}
\item \href{#method-ref_genome-gc_prop}{\code{ref_genome$gc_prop()}}
\item \href{#method-ref_genome-nt_prop}{\code{ref_genome$nt_prop()}}
\item \href{#method-ref_genome-set_names}{\code{ref_genome$set_names()}}
\item \href{#method-ref_genome-clean_names}{\code{ref_genome$clean_names()}}
\item \href{#method-ref_genome-add_chroms}{\code{ref_genome$add_chroms()}}
\item \href{#method-ref_genome-rm_chroms}{\code{ref_genome$rm_chroms()}}
\item \href{#method-ref_genome-merge_chroms}{\code{ref_genome$merge_chroms()}}
\item \href{#method-ref_genome-filter_chroms}{\code{ref_genome$filter_chroms()}}
\item \href{#method-ref_genome-replace_Ns}{\code{ref_genome$replace_Ns()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-new"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-new}{}}}
\subsection{Method \code{new()}}{
Do NOT use this; only use \code{read_fasta} or \code{create_genome} to make a
new \code{ref_genome}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$new(genome_ptr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genome_ptr}}{An \code{externalptr} object pointing to a C++ object that stores
the information about the reference genome.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-print"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{ref_genome} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-ptr"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-ptr}{}}}
\subsection{Method \code{ptr()}}{
View pointer to underlying C++ object (this is not useful to end users).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$ptr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{externalptr} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-n_chroms"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-n_chroms}{}}}
\subsection{Method \code{n_chroms()}}{
View number of chromosomes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$n_chroms()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer number of chromosomes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-sizes"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-sizes}{}}}
\subsection{Method \code{sizes()}}{
View chromosome sizes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$sizes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer vector of chromosome sizes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-chrom_names"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-chrom_names}{}}}
\subsection{Method \code{chrom_names()}}{
View chromosome names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$chrom_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of chromosome names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-chrom"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-chrom}{}}}
\subsection{Method \code{chrom()}}{
View one reference chromosome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$chrom(chrom_ind)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chrom_ind}}{Index for the focal chromosome.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single string representing the chosen chromosome's DNA sequence.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-gc_prop"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-gc_prop}{}}}
\subsection{Method \code{gc_prop()}}{
View GC proportion for part of one reference chromosome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$gc_prop(chrom_ind, start, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{start}}{Point on the chromosome at which to start the calculation
(inclusive).}

\item{\code{end}}{Point on the chromosome at which to end the calculation
(inclusive).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A double in the range \verb{[0,1]} representing the proportion of DNA
sequence that is either \code{G} or \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-nt_prop"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-nt_prop}{}}}
\subsection{Method \code{nt_prop()}}{
View nucleotide content for part of one reference chromosome
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$nt_prop(nt, chrom_ind, start, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nt}}{Which nucleotide to calculate the proportion that the DNA
sequence is made of. Must be one of \code{T}, \code{C}, \code{A}, \code{G}, or \code{N}.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{start}}{Point on the chromosome at which to start the calculation
(inclusive).}

\item{\code{end}}{Point on the chromosome at which to end the calculation
(inclusive).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A double in the range \verb{[0,1]} representing the proportion of DNA
sequence that is \code{nt}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-set_names"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-set_names}{}}}
\subsection{Method \code{set_names()}}{
Change chromosome names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$set_names(new_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_names}}{Vector of new names to use. This must be the same length as
the number of current names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ref <- create_genome(4, 10)
ref$set_names(c("a", "b", "c", "d"))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-clean_names"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-clean_names}{}}}
\subsection{Method \code{clean_names()}}{
Clean chromosome names, converting \verb{" :;=\%,\\\\|/\\"\\'"} to \code{"_"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$clean_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This \code{R6} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ref <- create_genome(4, 10)
ref$set_names(c("a:", "b|", "c;", "d'"))
ref$clean_names()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-add_chroms"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-add_chroms}{}}}
\subsection{Method \code{add_chroms()}}{
Add one or more chromosomes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$add_chroms(new_chroms, new_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_chroms}}{Character vector of DNA strings representing new chromosomes.}

\item{\code{new_names}}{Optional character vector of names for the new chromosomes.
It should be the same length as \code{new_chroms}.
If \code{NULL}, new names will be automatically generated. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ref <- create_genome(4, 10)
ref$add_chroms("TCAGTCAG")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-rm_chroms"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-rm_chroms}{}}}
\subsection{Method \code{rm_chroms()}}{
Remove one or more chromosomes by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$rm_chroms(chrom_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chrom_names}}{Vector of the name(s) of the chromosome(s) to remove.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ref <- create_genome(4, 10)
ref$set_names(c("a", "b", "c", "d"))
ref$rm_chroms("b")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-merge_chroms"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-merge_chroms}{}}}
\subsection{Method \code{merge_chroms()}}{
Merge chromosomes into one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$merge_chroms(chrom_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chrom_names}}{Vector of the names of the chromosomes to merge into one.
Duplicates are not allowed, and chromosomes are merged in the order
they're provided.
If this is \code{NULL}, then all chromosomes are merged after first
shuffling their order.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ref <- create_genome(4, 10)
ref$merge_chroms(ref$chrom_names()[1:2])
ref$merge_chroms(NULL)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-filter_chroms"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-filter_chroms}{}}}
\subsection{Method \code{filter_chroms()}}{
Filter chromosomes by size or for a proportion of total bases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$filter_chroms(threshold, method)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{Number used as a threshold. If \code{method == "size"},
then this is the minimum length of a chromosome that will remain after
filtering.
If \code{method == "prop"}, chromosomes are first size-sorted, then
the largest \code{N} chromosomes are retained that allow at least
\verb{threshold * sum(<all chromosome sizes>)} base pairs remaining after
filtering.}

\item{\code{method}}{String indicating which filter method to use: chromosome size
(\code{method = "size"}) or proportion of total bases (\code{method = "prop"}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ref <- create_genome(4, 100, 50)
ref$filter_chroms(90, "size")
ref$filter_chroms(0.4, "prop")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ref_genome-replace_Ns"></a>}}
\if{latex}{\out{\hypertarget{method-ref_genome-replace_Ns}{}}}
\subsection{Method \code{replace_Ns()}}{
Replace \code{N}s in the reference genome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ref_genome$replace_Ns(pi_tcag, n_threads = 1, show_progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pi_tcag}}{Numeric vector (length 4) indicating the sampling weights
for \code{T}, \code{C}, \code{A}, and \code{G}, respectively, for generating new nucleotides
with which to replace the \code{N}s.}

\item{\code{n_threads}}{Optional integer specifying the threads to use.
Ignored if the package wasn't compiled with OpenMP. Defaults to \code{1}.}

\item{\code{show_progress}}{Optional logical indicating whether to show a
progress bar. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
}
