% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_NA.R
\name{convert_to_NA}
\alias{convert_to_NA}
\title{Convert string values to true \code{NA} values.}
\usage{
convert_to_NA(dat, strings)
}
\arguments{
\item{dat}{vector or data.frame to operate on.}

\item{strings}{character vector of strings to convert.}
}
\value{
Returns a cleaned object.  Can be a vector, data.frame, or \code{tibble::tbl_df} depending on the provided input.
}
\description{
Converts instances of user-specified strings into \code{NA}.  Can operate on either a single vector or an entire data.frame.
}
\examples{
convert_to_NA(mtcars, "4") # a silly example;
# mtcars has no string NA values, but this will convert 4s to NA

# a more typical call would be (not run):
# convert_to_NA(my_df, c("NA", "#N/A", "N/A", "n/a", "#NAME?"))
# catches common strings that should be NA

convert_to_NA(letters, c("b", "d"))
}

