% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_val.R
\name{get_node_val}
\alias{get_node_val}
\title{Computes the test statistic at the current node.}
\usage{
get_node_val(f1, f2, data, lrt = TRUE, ...)
}
\arguments{
\item{f1}{a two-sided formula of the fitted survival model, without the longitudinal outcome in 
the right side of the formula. Only needed when \code{lrt}=TRUE.}

\item{f2}{a two-sided formula of the fitted survival model, same as \code{f1} but with the longitudinal outcome 
being the first covariate on the right side of the formula.}

\item{data}{a data.frame containing covariates in \code{f2}.}

\item{lrt}{if TRUE, use likelihood ratio test, otherwise use 
Wald test. Default is TRUE.}

\item{...}{further arguments to pass to or from other methods.}
}
\value{
The test statistic at the current node.
}
\description{
Computes the test statistic at the current node.
 Not to be called directly by the user.
}
\examples{
 data(data_timevar);
 f1 <- Surv(time_L, time_Y, delta)~X3+X4+X5;
 f2 <- Surv(time_L, time_Y, delta)~y+X3+X4+X5;
 get_node_val(f1, f2, data_timevar, lrt=TRUE);

}
\seealso{
\code{\link{get_lrt},\link{get_wald}}
}
