test_that("arrange_cols_omv works", {
    set.seed(1)
    tmpDF <- stats::setNames(as.data.frame(matrix(sample(6, 1200, replace = TRUE), nrow = 16)), sprintf("sbj_%03d", seq(75)))
    nmeInp <- paste0(tempfile(), ".rds")
    nmeOut <- paste0(tempfile(), "_T.omv")
    saveRDS(tmpDF, nmeInp)

    transpose_omv(dtaInp = tmpDF, fleOut = nmeOut)
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("V_%d", seq(16))))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("character", rep("integer", 16)))
    unlink(nmeOut)

    transpose_omv(dtaInp = cbind(list(qstItm = sprintf("Qst_%02d", seq(16))), tmpDF), fleOut = nmeOut, nmeVar = "qstItm")
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("Qst_%02d", seq(16))))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("character", rep("integer", 16)))
    unlink(nmeOut)

    transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, nmeVar = sprintf("Trl_%02d", seq(16)))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("Trl_%02d", seq(16))))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("character", rep("integer", 16)))
    unlink(nmeOut)

    transpose_omv(dtaInp = nmeInp, fleOut = nmeOut)
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("V_%d", seq(16))))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("character", rep("integer", 16)))
    unlink(nmeOut)
    unlink(nmeInp)

    expect_error(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, nmeVar = "notExist"))
    expect_error(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, nmeVar = 1))
    expect_error(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, nmeVar = c("Qst_01", "Qst_02")))
})
