% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.mjoint.R
\name{ranef.mjoint}
\alias{ranef.mjoint}
\title{Extract random effects estimates from an \code{mjoint} object}
\usage{
\method{ranef}{mjoint}(object, postVar = FALSE, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{mjoint} for a joint model
of time-to-event and multivariate longitudinal data.}

\item{postVar}{logical: if \code{TRUE} the variance of the posterior
distribution is also returned.}

\item{...}{additional arguments; currently none are used.}
}
\value{
A numeric matrix with rows denoting the individuals and columns the
  random effects (e.g., intercepts, slopes, etc.). If \code{postVar=TRUE},
  the numeric matrix has an extra attribute ``postVar".
}
\description{
Extract random effects estimates from an \code{mjoint} object.
}
\examples{
\dontrun{
# Fit a joint model with bivariate longitudinal outcomes

data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]

fit2 <- mjoint(
    formLongFixed = list("grad" = log.grad ~ time + sex + hs,
                         "lvmi" = log.lvmi ~ time + sex),
    formLongRandom = list("grad" = ~ 1 | num,
                          "lvmi" = ~ time | num),
    formSurv = Surv(fuyrs, status) ~ age,
    data = list(hvd, hvd),
    inits = list("gamma" = c(0.11, 1.51, 0.80)),
    timeVar = "time",
    verbose = TRUE)

ranef(fit2)
}
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\references{
Pinheiro JC, Bates DM. \emph{Mixed-Effects Models in S and S-PLUS.} New York:
Springer Verlag; 2000.

Wulfsohn MS, Tsiatis AA. A joint model for survival and longitudinal data
measured with error. \emph{Biometrics.} 1997; \strong{53(1)}: 330-339.
}
\seealso{
\code{\link[nlme]{ranef}} for the generic method description, and
  \code{\link{fixef.mjoint}}.
}
\keyword{methods}

