% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict.joinet}
\alias{predict.joinet}
\title{Make Predictions}
\usage{
\method{predict}{joinet}(object, newx, type = "response", ...)
}
\arguments{
\item{object}{\link[joinet]{joinet} object}

\item{newx}{covariates\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{type}{character "link" or "response"}

\item{...}{further arguments (not applicable)}
}
\value{
This function returns predictions from base and meta learners.
The slots \code{base} and \code{meta} each contain a matrix
with \eqn{n} rows (samples) and \eqn{q} columns (variables).
}
\description{
Predicts outcome from features with stacked model.
}
\examples{
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
object <- joinet(Y=Y,X=X)
predict(object,newx=X)

}
