% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbr2bib.R
\name{abbr2bib}
\alias{abbr2bib}
\title{Journal field abbreviation of BibTeX file}
\usage{
abbr2bib(
  file,
  outfile = tempfile(fileext = ".bib"),
  addcsvpath = "",
  csvsep = ";",
  csvheader = FALSE,
  ...
)
}
\arguments{
\item{file}{character, input a .bib file.}

\item{outfile}{character, file path to write the .bib file. An empty character string writes to \code{stdout} (default).}

\item{addcsvpath}{path, Users can customize the path of journal abbreviation. The CSV file requires semicolon to segment data without header. The first column is the full name of the journal and the second column is the journal abbreviation.}

\item{csvsep}{character, Customize the separator of CSV files. The default is semicolon, that is \code{;}.}

\item{csvheader}{logical, By default \code{FALSE}.}

\item{...}{(generalized), Parameters from \code{data.table::fread}.}
}
\value{
{
output a new Bib file in the current directory,
which only abbreviates the journal fields, and the rest remains unchanged.
And return to a tibble, it has four columns:
}
\describe{
\item{JOURNAL}{Original journal field in bib}
\item{journal_abbr}{Field after abbreviation of original journal}
\item{originFile}{Abbreviate the source of the database file, see \url{https://github.com/JabRef/abbrv.jabref.org/tree/master/journals}}
\item{is_abbr}{There are only three cases, 1 represents that the item has a JOURNAL field and has been abbreviated successfully, - 1 means that the item does not have a JOURNAL field, and 0 represents that the item has a JOURNAL field, but the corresponding abbreviation is not found in the database, so the original JOURNAL field is used instead}
}
}
\description{
Input Bib file with complete journal, output Bib file after abbreviation of journal, and return to the abbreviation table of journal
}
\examples{
require(journalabbr)
path = system.file("extdata", "testfile_1.bib", package = "journalabbr", mustWork = TRUE)
temptab = abbr2bib(file = path, outfile =  tempfile(fileext = ".bib"))

# add user csv
csvpath = system.file("extdata", "myabbr.csv", package = "journalabbr", mustWork = TRUE)
temptab1 = abbr2bib(file = path, outfile =  tempfile(fileext = ".bib"), addcsvpath = csvpath)

}
\keyword{List}
\keyword{abbreviations}
\keyword{bib}
\keyword{file}
\keyword{for}
\keyword{input}
\keyword{journal}
\keyword{of}
