% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords_to_mesh.R
\name{coords_to_mesh}
\alias{coords_to_mesh}
\title{Convert from coordinate to mesh code}
\usage{
coords_to_mesh(longitude, latitude, mesh_size = 1, geometry = NULL, ...)
}
\arguments{
\item{longitude}{longitude that approximately to .120.0 to 154.0 (\code{double})}

\item{latitude}{latitude that approximately to 20.0 to 46.0 (\code{double})}

\item{mesh_size}{Gives the unit in km for target mesh type.
That is, 1 for 1km, and 0.5 for 500m. From 80km to 125m. Default is 1.}

\item{geometry}{XY sfg object}

\item{...}{other parameters}
}
\value{
mesh code (default 3rd meshcode aka 1km mesh)
}
\description{
From coordinate to mesh codes.
}
\examples{
coords_to_mesh(141.3468, 43.06462, mesh_size = 1)
coords_to_mesh(139.6917, 35.68949, mesh_size = 0.250)
coords_to_mesh(139.71475, 35.70078)
# Using sf (point as sfg object)
library(sf)
coords_to_mesh(geometry = st_point(c(139.71475, 35.70078)))
coords_to_mesh(geometry = st_point(c(130.4412895, 30.2984335)))
}
\references{
Akio Takenaka: \url{http://takenaka-akio.org/etc/j_map/index.html} # nolint
}
\seealso{
\code{\link[=mesh_to_coords]{mesh_to_coords()}} for convert from meshcode to coordinates
}
