% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar.R
\name{barUI}
\alias{barUI}
\title{barUI: shiny module UI for barplot}
\usage{
barUI(id, label = "barplot")
}
\arguments{
\item{id}{id}

\item{label}{label}
}
\value{
Shiny module UI for barplot
}
\description{
Shiny module UI for barplot
}
\details{
Shiny module UI for barplot
}
\examples{
library(shiny)
library(ggplot2)
library(ggpubr)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      barUI("bar")
    ),
    mainPanel(
      plotOutput("bar_plot"),
      ggplotdownUI("bar")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_bar <- barServer("bar",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$bar_plot <- renderPlot({
    print(out_bar())
  })
}
}
