/*
 * Decompiled with CFR 0.152.
 */
package org.fgilbert.jsr223;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.fgilbert.jdx.JavaToR;
import org.fgilbert.jsr223.CallbackSetValue;
import org.fgilbert.jsr223.EvaluationThread;
import org.fgilbert.jsr223.Message;
import org.fgilbert.jsr223.RClient;
import org.fgilbert.jsr223.RequestEvaluation;
import org.fgilbert.jsr223.RequestInvokeFunction;
import org.fgilbert.jsr223.RequestInvokeMethod;
import org.fgilbert.jsr223.SilentWriter;

public class Controller {
    public static final int CALLBACK_EVALUATION = 0x1000000;
    public static final int CALLBACK_GET_VALUE = 0x2000000;
    public static final int CALLBACK_SET_VALUE = 0x3000000;
    private final int STANDARD_OUTPUT_BUFFER_SIZE_DEFAULT = 4096;
    private final int STANDARD_OUTPUT_BUFFER_SIZE_MAX = 4096000;
    private JavaToR.ArrayOrder arrayOrder = JavaToR.ArrayOrder.ROW_MAJOR;
    private ScriptEngine engine;
    private String[][] engineInformation;
    private EvaluationThread evaluationThread;
    private boolean initialized;
    private ScriptEngineManager manager = new ScriptEngineManager();
    private ArrayBlockingQueue<JavaToR> queue = new ArrayBlockingQueue(1);
    private RClient rClient;
    private JavaToR response = new JavaToR();
    private StandardOutputMode standardOutputMode = StandardOutputMode.CONSOLE;

    public Controller(String engineShortName) throws Exception {
        ScriptEngineFactory factory = null;
        if (engineShortName.compareTo("kotlin") != 0) {
            this.engine = this.manager.getEngineByName(engineShortName);
            if (this.engine == null) {
                throw new Exception(String.format("Failed to instantiate engine '%s'. Make sure the engine dependencies are in the class path.", engineShortName));
            }
            factory = this.engine.getFactory();
        } else {
            Class<?> cls = Class.forName("org.jetbrains.kotlin.script.jsr223.KotlinJsr223JvmLocalScriptEngineFactory");
            factory = (ScriptEngineFactory)cls.newInstance();
            this.engine = factory.getScriptEngine();
        }
        this.engineInformation = new String[][]{{"name", "short.names", "version", "language.name", "language.version", "extensions", "mime.types"}, {factory.getEngineName(), factory.getNames().toString(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion(), factory.getExtensions().toString(), factory.getMimeTypes().toString()}};
        this.evaluationThread = new EvaluationThread(this, this.engine);
        this.evaluationThread.start();
        this.rClient = new RClient(this, this.evaluationThread);
        this.engine.put("R", this.rClient);
        if (engineShortName.compareTo("kotlin") == 0) {
            this.engine.eval("val R = bindings[\"R\"] as org.fgilbert.jsr223.RClient");
        }
        this.initialized = true;
    }

    public void clearStandardOutput() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        try {
            StringWriter sw = (StringWriter)this.engine.getContext().getWriter();
            StringBuffer sb = sw.getBuffer();
            if (sb.length() > 4096000) {
                sb.setLength(4096000);
                sb.trimToSize();
                sb.ensureCapacity(4096000);
            }
            sb.setLength(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CompiledScript compileScript(String script) throws ScriptException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        Compilable comp = (Compilable)((Object)this.engine);
        return comp.compile(script);
    }

    public JavaToR.ArrayOrder getArrayOrder() {
        return this.arrayOrder;
    }

    public int getBindings() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        Bindings m = this.engine.getBindings(100);
        TreeMap<String, String> tm = new TreeMap<String, String>((a, b) -> {
            int n = a.compareToIgnoreCase((String)b);
            if (n != 0) {
                return n;
            }
            return a.compareTo((String)b);
        });
        Object value = null;
        for (Map.Entry me : m.entrySet()) {
            value = me.getValue();
            if (value == null) {
                tm.put((String)me.getKey(), "null");
                continue;
            }
            tm.put((String)me.getKey(), value.getClass().getName());
        }
        return this.response.initialize(tm, this.arrayOrder);
    }

    public String[][] getEngineInformation() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.engineInformation;
    }

    public JavaToR getResponse() {
        return this.response;
    }

    public String[] getResponseCallbackSetValue() {
        CallbackSetValue cpv = (CallbackSetValue)this.response.getValueObject();
        return new String[]{cpv.getKey(), Integer.toString(this.response.initializeFrom(cpv.getValue()))};
    }

    public int getScriptEngineValue(String key) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.response.initialize(this.engine.get(key), this.arrayOrder);
    }

    public String getScriptEngineValueClassName(String key) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        Object o = this.engine.get(key);
        return o == null ? null : o.getClass().getName();
    }

    public StandardOutputMode getStandardOutputMode() {
        return this.standardOutputMode;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getStandardOutput() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        try {
            StringWriter sw = (StringWriter)this.engine.getContext().getWriter();
            String result = sw.toString();
            this.clearStandardOutput();
            return result;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void putCallbackResponse(boolean value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(boolean[] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(boolean[][] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(byte value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(byte[] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(byte[][] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(double value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(double[] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(double[][] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(int value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(int[] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(int[][] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(List<?> value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(Map<?, ?> value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(Object value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(String value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(String[] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponse(String[][] value) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_OK, value));
    }

    public void putCallbackResponseError(String errorMessage) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.RESPONSE, Message.Subject.RSP_ERROR, errorMessage));
    }

    public void putEvaluationRequest(CompiledScript compiledScript, boolean discardReturnValue) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_EVALUATE, new RequestEvaluation(compiledScript, discardReturnValue, null)));
    }

    public void putEvaluationRequest(CompiledScript compiledScript, boolean discardReturnValue, Map<String, Object> bindings) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        SimpleBindings sb = null;
        if (bindings != null) {
            sb = new SimpleBindings(bindings);
            sb.put("R", (Object)this.rClient);
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_EVALUATE, new RequestEvaluation(compiledScript, discardReturnValue, (Bindings)sb)));
    }

    public void putEvaluationRequest(String script, boolean discardReturnValue) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_EVALUATE, new RequestEvaluation(script, discardReturnValue, null)));
    }

    public void putEvaluationRequest(String script, boolean discardReturnValue, Map<String, Object> bindings) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        SimpleBindings sb = null;
        if (bindings != null) {
            sb = new SimpleBindings(bindings);
            sb.put("R", (Object)this.rClient);
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_EVALUATE, new RequestEvaluation(script, discardReturnValue, (Bindings)sb)));
    }

    public void putInvokeFunctionRequest(String functionName, Object ... arguments) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_INVOKE_FUNCTION, new RequestInvokeFunction(functionName, arguments)));
    }

    public void putInvokeMethodRequest(String objectName, String methodName, Object ... arguments) throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_INVOKE_METHOD, new RequestInvokeMethod(objectName, methodName, arguments)));
    }

    void putQueueItem(JavaToR j2r) throws InterruptedException {
        this.queue.put(j2r);
    }

    public boolean removeScriptEngineValue(String key) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.engine.getBindings(100).remove(key) != null;
    }

    public void setArrayOrder(JavaToR.ArrayOrder value) {
        this.arrayOrder = value;
    }

    public void setScriptEngineValue(String key, boolean value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, boolean[] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, boolean[][] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, byte value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, byte[] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, byte[][] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, double value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, double[] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, double[][] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, int value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, int[] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, int[][] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, List<?> value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, Map<?, ?> value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, Object value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, String value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, String[] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setScriptEngineValue(String key, String[][] value) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.engine.put(key, value);
    }

    public void setStandardOutputMode(StandardOutputMode value) {
        this.standardOutputMode = value;
        switch (value) {
            case CONSOLE: {
                this.engine.getContext().setWriter(new SimpleScriptContext().getWriter());
                break;
            }
            case QUIET: {
                this.engine.getContext().setWriter(new SilentWriter());
                break;
            }
            case BUFFER: {
                Writer writer = this.engine.getContext().getWriter();
                if (writer != null && StringWriter.class.equals(writer.getClass())) break;
                this.engine.getContext().setWriter(new StringWriter(4096));
            }
        }
    }

    public void terminate() throws InterruptedException {
        if (!this.initialized) {
            return;
        }
        this.evaluationThread.putQueueItem(new Message(Message.MessageType.REQUEST, Message.Subject.RQ_QUIT, null));
        this.engine = null;
        this.evaluationThread = null;
        this.manager = null;
        this.rClient = null;
        this.initialized = false;
    }

    public int waitForEvaluation() throws InterruptedException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.response.initializeFrom(this.queue.take());
    }

    public static enum StandardOutputMode {
        CONSOLE,
        QUIET,
        BUFFER;

    }
}

